/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import java.beans.ConstructorProperties;
import java.util.UUID;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AttributeUpdate {
    private final UUID attributeId;
    private final AttributeUpdateType updateType;
    private long value;
    private final long comparisonValue;

    public AttributeUpdate(UUID attributeId, AttributeUpdateType updateType, long value) {
        this(attributeId, updateType, value, Long.MIN_VALUE);
        Preconditions.checkArgument((updateType != AttributeUpdateType.ReplaceIfEquals ? 1 : 0) != 0, (Object)"Cannot use this constructor with ReplaceIfEquals.");
    }

    public String toString() {
        return String.format("AttributeId = %s, Value = %s, UpdateType = %s", new Object[]{this.attributeId, this.value, this.updateType});
    }

    @ConstructorProperties(value={"attributeId", "updateType", "value", "comparisonValue"})
    @SuppressFBWarnings(justification="generated code")
    public AttributeUpdate(UUID attributeId, AttributeUpdateType updateType, long value, long comparisonValue) {
        this.attributeId = attributeId;
        this.updateType = updateType;
        this.value = value;
        this.comparisonValue = comparisonValue;
    }

    @SuppressFBWarnings(justification="generated code")
    public UUID getAttributeId() {
        return this.attributeId;
    }

    @SuppressFBWarnings(justification="generated code")
    public AttributeUpdateType getUpdateType() {
        return this.updateType;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getValue() {
        return this.value;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getComparisonValue() {
        return this.comparisonValue;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setValue(long value) {
        this.value = value;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeUpdate)) {
            return false;
        }
        AttributeUpdate other = (AttributeUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$attributeId = this.getAttributeId();
        UUID other$attributeId = other.getAttributeId();
        if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
            return false;
        }
        AttributeUpdateType this$updateType = this.getUpdateType();
        AttributeUpdateType other$updateType = other.getUpdateType();
        if (this$updateType == null ? other$updateType != null : !((Object)((Object)this$updateType)).equals((Object)other$updateType)) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        return this.getComparisonValue() == other.getComparisonValue();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof AttributeUpdate;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $attributeId = this.getAttributeId();
        result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
        AttributeUpdateType $updateType = this.getUpdateType();
        result = result * 59 + ($updateType == null ? 43 : ((Object)((Object)$updateType)).hashCode());
        long $value = this.getValue();
        result = result * 59 + (int)($value >>> 32 ^ $value);
        long $comparisonValue = this.getComparisonValue();
        result = result * 59 + (int)($comparisonValue >>> 32 ^ $comparisonValue);
        return result;
    }
}

