/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class Attributes {
    public static final long TABLE_ATTRIBUTES_START_OFFSET = 0x100000L;
    public static final long NULL_ATTRIBUTE_VALUE = Long.MIN_VALUE;
    public static final long CORE_ATTRIBUTE_ID_PREFIX = Long.MIN_VALUE;
    public static final UUID CREATION_TIME = new UUID(Long.MIN_VALUE, 0L);
    public static final UUID EVENT_COUNT = new UUID(Long.MIN_VALUE, 1L);
    public static final UUID SCALE_POLICY_TYPE = new UUID(Long.MIN_VALUE, 2L);
    public static final UUID SCALE_POLICY_RATE = new UUID(Long.MIN_VALUE, 3L);
    public static final UUID ROLLOVER_SIZE = new UUID(Long.MIN_VALUE, 4L);
    private static final UUID RETIRED_1 = new UUID(Long.MIN_VALUE, 5L);
    private static final UUID RETIRED_2 = new UUID(Long.MIN_VALUE, 6L);

    public static boolean isCoreAttribute(UUID attributeId) {
        return attributeId.getMostSignificantBits() == Long.MIN_VALUE;
    }

    public static Map<UUID, Long> getCoreNonNullAttributes(Map<UUID, Long> attributes) {
        return attributes.entrySet().stream().filter(e -> Attributes.isCoreAttribute((UUID)e.getKey()) && (Long)e.getValue() != Long.MIN_VALUE).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

