/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import java.util.UUID;

public class BadAttributeUpdateException
extends StreamSegmentException {
    private static final long serialVersionUID = 1L;
    private final boolean previousValueMissing;
    private final UUID attributeId;

    public BadAttributeUpdateException(String streamSegmentName, AttributeUpdate attributeUpdate, boolean previousValueMissing, String errorMessage) {
        super(streamSegmentName, BadAttributeUpdateException.getMessage(attributeUpdate, previousValueMissing, errorMessage));
        this.previousValueMissing = previousValueMissing;
        this.attributeId = attributeUpdate == null ? null : attributeUpdate.getAttributeId();
    }

    private static String getMessage(AttributeUpdate attributeUpdate, boolean previousValueMissing, String errorMessage) {
        return String.format("Bad Attribute Update (%s): %s%s.", attributeUpdate, errorMessage, previousValueMissing ? " (missing value)" : "");
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isPreviousValueMissing() {
        return this.previousValueMissing;
    }

    @SuppressFBWarnings(justification="generated code")
    public UUID getAttributeId() {
        return this.attributeId;
    }
}

