/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.util.ImmutableDate;
import io.pravega.segmentstore.contracts.SegmentProperties;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public class StreamSegmentInformation
implements SegmentProperties {
    private final String name;
    private final long startOffset;
    private final long length;
    private final boolean sealed;
    private final boolean deleted;
    private final ImmutableDate lastModified;
    private final Map<UUID, Long> attributes;

    private StreamSegmentInformation(String name, long startOffset, long length, boolean sealed, boolean deleted, Map<UUID, Long> attributes, ImmutableDate lastModified) {
        Preconditions.checkArgument((startOffset >= 0L ? 1 : 0) != 0, (Object)"startOffset must be a non-negative number.");
        Preconditions.checkArgument((length >= startOffset ? 1 : 0) != 0, (Object)"length must be a non-negative number and greater than startOffset.");
        this.name = Exceptions.checkNotNullOrEmpty((String)name, (String)"name");
        this.startOffset = startOffset;
        this.length = length;
        this.sealed = sealed;
        this.deleted = deleted;
        this.lastModified = lastModified == null ? new ImmutableDate() : lastModified;
        this.attributes = StreamSegmentInformation.createAttributes(attributes);
    }

    public static StreamSegmentInformationBuilder from(SegmentProperties base) {
        return StreamSegmentInformation.builder().name(base.getName()).startOffset(base.getStartOffset()).length(base.getLength()).sealed(base.isSealed()).deleted(base.isDeleted()).lastModified(base.getLastModified()).attributes(base.getAttributes());
    }

    public String toString() {
        return String.format("Name = %s, StartOffset = %d, Length = %d, Sealed = %s, Deleted = %s", this.getName(), this.getStartOffset(), this.getLength(), this.isSealed(), this.isDeleted());
    }

    private static Map<UUID, Long> createAttributes(Map<UUID, Long> input) {
        return input == null || input.size() == 0 ? Collections.emptyMap() : Collections.unmodifiableMap(input);
    }

    @SuppressFBWarnings(justification="generated code")
    public static StreamSegmentInformationBuilder builder() {
        return new StreamSegmentInformationBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getName() {
        return this.name;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public long getStartOffset() {
        return this.startOffset;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public long getLength() {
        return this.length;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public ImmutableDate getLastModified() {
        return this.lastModified;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public Map<UUID, Long> getAttributes() {
        return this.attributes;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class StreamSegmentInformationBuilder {
        @SuppressFBWarnings(justification="generated code")
        private String name;
        @SuppressFBWarnings(justification="generated code")
        private long startOffset;
        @SuppressFBWarnings(justification="generated code")
        private long length;
        @SuppressFBWarnings(justification="generated code")
        private boolean sealed;
        @SuppressFBWarnings(justification="generated code")
        private boolean deleted;
        @SuppressFBWarnings(justification="generated code")
        private Map<UUID, Long> attributes;
        @SuppressFBWarnings(justification="generated code")
        private ImmutableDate lastModified;

        @SuppressFBWarnings(justification="generated code")
        StreamSegmentInformationBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentInformationBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentInformationBuilder startOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentInformationBuilder length(long length) {
            this.length = length;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentInformationBuilder sealed(boolean sealed) {
            this.sealed = sealed;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentInformationBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentInformationBuilder attributes(Map<UUID, Long> attributes) {
            this.attributes = attributes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentInformationBuilder lastModified(ImmutableDate lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentInformation build() {
            return new StreamSegmentInformation(this.name, this.startOffset, this.length, this.sealed, this.deleted, this.attributes, this.lastModified);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "StreamSegmentInformation.StreamSegmentInformationBuilder(name=" + this.name + ", startOffset=" + this.startOffset + ", length=" + this.length + ", sealed=" + this.sealed + ", deleted=" + this.deleted + ", attributes=" + this.attributes + ", lastModified=" + this.lastModified + ")";
        }
    }
}

