/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts.tables;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.HashedArray;
import java.beans.ConstructorProperties;
import lombok.NonNull;

public class TableKey {
    public static final long NO_VERSION = Long.MIN_VALUE;
    public static final long NOT_EXISTS = -1L;
    private final ArrayView key;
    private final long version;

    public static TableKey unversioned(@NonNull ArrayView key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return new TableKey(key, Long.MIN_VALUE);
    }

    public static TableKey notExists(@NonNull ArrayView key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return new TableKey(key, -1L);
    }

    public static TableKey versioned(@NonNull ArrayView key, long version) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Preconditions.checkArgument((version >= 0L || version == -1L || version == Long.MIN_VALUE ? 1 : 0) != 0, (Object)"Version must be a non-negative number.");
        return new TableKey(key, version);
    }

    public boolean hasVersion() {
        return this.version != Long.MIN_VALUE;
    }

    public String toString() {
        return String.format("{%s} %s", this.hasVersion() ? Long.valueOf(this.version) : "*", this.key);
    }

    public int hashCode() {
        return HashedArray.hashCode((ArrayView)this.key);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableKey) {
            TableKey other = (TableKey)obj;
            return HashedArray.arrayEquals((ArrayView)this.key, (ArrayView)other.key) && this.version == other.version;
        }
        return false;
    }

    @SuppressFBWarnings(justification="generated code")
    public ArrayView getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getVersion() {
        return this.version;
    }

    @ConstructorProperties(value={"key", "version"})
    @SuppressFBWarnings(justification="generated code")
    private TableKey(ArrayView key, long version) {
        this.key = key;
        this.version = version;
    }
}

