/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts.tables;

import com.google.common.annotations.Beta;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.AsyncIterator;
import io.pravega.segmentstore.contracts.tables.IteratorItem;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@Beta
public interface TableStore {
    default public int maximumKeyLength() {
        return 8192;
    }

    default public int maximumValueLength() {
        return 1040384;
    }

    public CompletableFuture<Void> createSegment(String var1, Duration var2);

    public CompletableFuture<Void> deleteSegment(String var1, boolean var2, Duration var3);

    public CompletableFuture<Void> merge(String var1, String var2, Duration var3);

    public CompletableFuture<Void> seal(String var1, Duration var2);

    public CompletableFuture<List<Long>> put(String var1, List<TableEntry> var2, Duration var3);

    public CompletableFuture<Void> remove(String var1, Collection<TableKey> var2, Duration var3);

    public CompletableFuture<List<TableEntry>> get(String var1, List<ArrayView> var2, Duration var3);

    public CompletableFuture<AsyncIterator<IteratorItem<TableKey>>> keyIterator(String var1, byte[] var2, Duration var3);

    public CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryIterator(String var1, byte[] var2, Duration var3);
}

