/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.cluster.zkImpl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.cluster.Cluster;
import io.pravega.common.cluster.ClusterException;
import io.pravega.common.cluster.ClusterListener;
import io.pravega.common.cluster.Host;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.nodes.PersistentNode;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterZKImpl
implements Cluster {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ClusterZKImpl.class);
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    private static final String PATH_CLUSTER = "/cluster/";
    private static final int INIT_SIZE = 3;
    private final String clusterName;
    private final CuratorFramework client;
    private final Map<Host, PersistentNode> entryMap = new HashMap<Host, PersistentNode>(3);
    private Optional<PathChildrenCache> cache = Optional.empty();

    public ClusterZKImpl(CuratorFramework zkClient, String clusterName) {
        this.client = zkClient;
        this.clusterName = clusterName;
        if (this.client.getState().equals((Object)CuratorFrameworkState.LATENT)) {
            this.client.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerHost(Host host) {
        Object object = this.$lock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)host, (Object)"host");
            Exceptions.checkArgument((!this.entryMap.containsKey(host) ? 1 : 0) != 0, (String)"host", (String)"host is already registered to cluster.", (Object[])new Object[0]);
            String hostPath = ZKPaths.makePath((String)this.getPathPrefix(), (String)host.toString());
            PersistentNode node = new PersistentNode(this.client, CreateMode.EPHEMERAL, false, hostPath, host.toBytes());
            node.start();
            this.entryMap.put(host, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterHost(Host host) {
        Object object = this.$lock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)host, (Object)"host");
            PersistentNode node = this.entryMap.get(host);
            Preconditions.checkNotNull((Object)node, (Object)"Host is not present in cluster.");
            this.entryMap.remove(host);
            this.close((Closeable)node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ClusterListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)listener, (Object)"listener");
            if (!this.cache.isPresent()) {
                this.initializeCache();
            }
            this.cache.get().getListenable().addListener((Object)this.pathChildrenCacheListener(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ClusterListener listener, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)listener, (Object)"listener");
            Preconditions.checkNotNull((Object)executor, (Object)"executor");
            if (!this.cache.isPresent()) {
                this.initializeCache();
            }
            this.cache.get().getListenable().addListener((Object)this.pathChildrenCacheListener(listener), executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Host> getClusterMembers() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.cache.isPresent()) {
                this.initializeCache();
            }
            List data = this.cache.get().getCurrentData();
            return data.stream().map(d -> Host.fromBytes(d.getData())).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Map<Host, PersistentNode> map = this.entryMap;
        synchronized (map) {
            this.entryMap.values().forEach(this::close);
            this.cache.ifPresent(this::close);
        }
    }

    private void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            log.error("Error while closing resource", (Throwable)e);
        }
    }

    private void initializeCache() throws ClusterException {
        this.cache = Optional.of(new PathChildrenCache(this.client, this.getPathPrefix(), true));
        try {
            this.cache.get().start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
        }
        catch (Exception e) {
            throw ClusterException.create(ClusterException.Type.METASTORE, "Failed to initialize ZooKeeper cache: " + e.getMessage());
        }
    }

    private PathChildrenCacheListener pathChildrenCacheListener(ClusterListener listener) {
        return (client, event) -> {
            log.debug("Event {} generated on cluster", (Object)event);
            switch (event.getType()) {
                case CHILD_ADDED: {
                    log.info("Node {} added to cluster", (Object)this.getServerName(event));
                    listener.onEvent(ClusterListener.EventType.HOST_ADDED, Host.fromBytes(event.getData().getData()));
                    break;
                }
                case CHILD_REMOVED: {
                    log.info("Node {} removed from cluster", (Object)this.getServerName(event));
                    listener.onEvent(ClusterListener.EventType.HOST_REMOVED, Host.fromBytes(event.getData().getData()));
                    break;
                }
                case CHILD_UPDATED: {
                    log.warn("Invalid usage: Node {} updated externally for cluster", (Object)this.getServerName(event));
                    break;
                }
                case CONNECTION_LOST: {
                    log.error("Connection lost with Zookeeper");
                    listener.onEvent(ClusterListener.EventType.ERROR, null);
                    break;
                }
                default: {
                    log.warn("Received unknown event {}", (Object)event.getType());
                }
            }
        };
    }

    private String getServerName(PathChildrenCacheEvent event) {
        String path = event.getData().getPath();
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private String getPathPrefix() {
        return ZKPaths.makePath((String)PATH_CLUSTER, (String)this.clusterName);
    }
}

