/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object;

import com.emc.object.EntityRequest;
import com.emc.object.ObjectConfig;
import com.emc.object.ObjectRequest;
import com.emc.object.ObjectResponse;
import com.emc.object.util.RestUtil;
import com.emc.rest.smart.SizeOverrideWriter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJerseyClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractJerseyClient.class);
    protected ObjectConfig objectConfig;

    protected AbstractJerseyClient(ObjectConfig objectConfig) {
        this.objectConfig = objectConfig;
    }

    protected ClientResponse executeAndClose(Client client, ObjectRequest request) {
        ClientResponse response = this.executeRequest(client, request);
        response.close();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientResponse executeRequest(Client client, ObjectRequest request) {
        try {
            if (request.getMethod().isRequiresEntity()) {
                String contentType = "application/octet-stream";
                Object entity = new byte[]{};
                if (request instanceof EntityRequest) {
                    EntityRequest entityRequest = (EntityRequest)((Object)request);
                    if (entityRequest.getContentType() != null) {
                        contentType = entityRequest.getContentType();
                    }
                    if (entityRequest.getEntity() != null) {
                        entity = entityRequest.getEntity();
                    }
                    if (entityRequest.getContentLength() != null) {
                        log.debug("enabling content-length override ({})", (Object)entityRequest.getContentLength().toString());
                        SizeOverrideWriter.setEntitySize(entityRequest.getContentLength());
                    } else if (!entityRequest.isChunkable()) {
                        log.debug("no content-length and request is not chunkable, attempting to enable buffering");
                        request.property("com.sun.jersey.impl.client.httpclient.enableBuffering", Boolean.TRUE);
                        request.property("com.sun.jersey.client.property.chunkedEncodingSize", null);
                    }
                } else {
                    request.property("com.sun.jersey.impl.client.httpclient.enableBuffering", Boolean.TRUE);
                    String headerContentType = RestUtil.getFirstAsString(request.getHeaders(), "Content-Type");
                    if (headerContentType != null) {
                        contentType = headerContentType;
                    }
                }
                WebResource.Builder builder = this.buildRequest(client, request);
                builder.type(contentType);
                ClientResponse clientResponse = (ClientResponse)builder.method(request.getMethod().toString(), ClientResponse.class, entity);
                return clientResponse;
            }
            if (request instanceof EntityRequest) {
                throw new UnsupportedOperationException("an entity request is using a non-entity method (" + (Object)((Object)request.getMethod()) + ")");
            }
            WebResource.Builder builder = this.buildRequest(client, request);
            ClientResponse clientResponse = (ClientResponse)builder.method(request.getMethod().toString(), ClientResponse.class);
            return clientResponse;
        }
        finally {
            SizeOverrideWriter.setEntitySize(null);
        }
    }

    protected <T> T executeRequest(Client client, ObjectRequest request, Class<T> responseType) {
        ClientResponse response = this.executeRequest(client, request);
        Object responseEntity = response.getEntity(responseType);
        this.fillResponseEntity(responseEntity, response);
        return (T)responseEntity;
    }

    protected void fillResponseEntity(Object responseEntity, ClientResponse response) {
        if (responseEntity instanceof ObjectResponse) {
            ((ObjectResponse)responseEntity).setHeaders((Map<String, List<String>>)response.getHeaders());
        }
    }

    protected WebResource.Builder buildRequest(Client client, ObjectRequest request) {
        String namespace;
        URI uri = this.objectConfig.resolvePath(request.getPath(), request.getRawQueryString());
        WebResource resource = client.resource(uri);
        for (Map.Entry<String, Object> entry : request.getProperties().entrySet()) {
            resource.setProperty(entry.getKey(), entry.getValue());
        }
        String string = namespace = request.getNamespace() != null ? request.getNamespace() : this.objectConfig.getNamespace();
        if (namespace != null) {
            resource.setProperty("com.emc.object.namespace", (Object)namespace);
        }
        WebResource.Builder builder = resource.getRequestBuilder();
        for (String name : request.getHeaders().keySet()) {
            for (Object value : request.getHeaders().get(name)) {
                builder = (WebResource.Builder)builder.header(name, value);
            }
        }
        return builder;
    }

    public ObjectConfig getObjectConfig() {
        return this.objectConfig;
    }
}

