/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object;

import com.emc.codec.compression.deflate.DeflateCodec;
import com.emc.codec.encryption.BasicKeyProvider;
import com.emc.codec.encryption.EncryptionCodec;
import com.emc.codec.encryption.KeyProvider;
import com.emc.codec.encryption.KeystoreKeyProvider;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EncryptionConfig {
    private String encryptionSpec = new EncryptionCodec().getDefaultEncodeSpec();
    private boolean compressionEnabled = false;
    private String compressionSpec = new DeflateCodec().getDefaultEncodeSpec();
    private Map<String, Object> codecProperties = new HashMap<String, Object>();

    public EncryptionConfig(KeyStore keystore, char[] masterKeyPassword, String masterKeyAlias) throws KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, UnrecoverableKeyException {
        this(new KeystoreKeyProvider(keystore, masterKeyPassword, masterKeyAlias));
    }

    public EncryptionConfig(KeyPair masterEncryptionKey, Set<KeyPair> decryptionKeys) {
        this(new BasicKeyProvider(masterEncryptionKey, decryptionKeys.toArray(new KeyPair[decryptionKeys.size()])));
    }

    public EncryptionConfig(KeyProvider keyProvider) {
        this.codecProperties.put("com.emc.codec.encryption.EncryptionCodec.keyProvider", keyProvider);
    }

    public EncryptionConfig(EncryptionConfig other) {
        this.encryptionSpec = other.encryptionSpec;
        this.compressionEnabled = other.compressionEnabled;
        this.compressionSpec = other.compressionSpec;
        this.codecProperties = new HashMap<String, Object>(this.codecProperties);
    }

    public KeyProvider getKeyProvider() {
        return EncryptionCodec.getKeyProvider(this.codecProperties);
    }

    public int getKeySize() {
        return EncryptionCodec.getKeySize(this.codecProperties);
    }

    public void setKeySize(int keySize) {
        EncryptionCodec.setKeySize(this.codecProperties, keySize);
    }

    public Provider getSecurityProvider() {
        return EncryptionCodec.getSecurityProvider(this.codecProperties);
    }

    public void setSecurityProvider(Provider provider) {
        EncryptionCodec.setPropSecurityProvider(this.codecProperties, provider);
    }

    public String getEncryptionSpec() {
        return this.encryptionSpec;
    }

    public void setEncryptionSpec(String encryptionSpec) {
        this.encryptionSpec = encryptionSpec;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public String getCompressionSpec() {
        return this.compressionSpec;
    }

    public void setCompressionSpec(String compressionSpec) {
        this.compressionSpec = compressionSpec;
    }

    public Map<String, Object> getCodecProperties() {
        return this.codecProperties;
    }

    public void setCodecProperties(Map<String, Object> codecProperties) {
        this.codecProperties = codecProperties;
    }

    public EncryptionConfig withKeySize(int keySize) {
        this.setKeySize(keySize);
        return this;
    }

    public EncryptionConfig withSecurityProvider(Provider provider) {
        this.setSecurityProvider(provider);
        return this;
    }

    public EncryptionConfig withEncryptionSpec(String encryptionSpec) {
        this.setEncryptionSpec(encryptionSpec);
        return this;
    }

    public EncryptionConfig withCompressionEnabled(boolean compressionEnabled) {
        this.setCompressionEnabled(compressionEnabled);
        return this;
    }

    public EncryptionConfig withCompressionSpec(String compressionSpec) {
        this.setCompressionSpec(compressionSpec);
        return this;
    }
}

