/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3;

import com.emc.object.ObjectConfig;
import com.emc.object.Protocol;
import com.emc.object.util.ConfigUriProperty;
import com.emc.rest.smart.Host;
import com.emc.rest.smart.ecs.Vdc;
import java.net.URI;

public class S3Config
extends ObjectConfig<S3Config> {
    public static final int DEFAULT_HTTP_PORT = 9020;
    public static final int DEFAULT_HTTPS_PORT = 9021;
    public static final int DEFAULT_INITIAL_RETRY_DELAY = 1000;
    public static final int DEFAULT_RETRY_LIMIT = 3;
    public static final int DEFAULT_RETRY_BUFFER_SIZE = 0x200000;
    protected boolean useVHost = false;
    protected boolean signNamespace = true;
    protected boolean checksumEnabled = true;
    protected boolean retryEnabled = true;
    protected int initialRetryDelay = 1000;
    protected int retryLimit = 3;
    protected int retryBufferSize = 0x200000;
    protected float faultInjectionRate = 0.0f;
    protected boolean signMetadataSearch = true;

    protected static int defaultPort(Protocol protocol) {
        if (protocol == Protocol.HTTP) {
            return 9020;
        }
        if (protocol == Protocol.HTTPS) {
            return 9021;
        }
        throw new IllegalArgumentException("unknown protocol: " + (Object)((Object)protocol));
    }

    public S3Config() {
    }

    public S3Config(URI endpoint) {
        super(endpoint);
    }

    public S3Config(Protocol protocol, String ... hostList) {
        super(protocol, S3Config.defaultPort(protocol), hostList);
    }

    public S3Config(Protocol protocol, Vdc ... vdcs) {
        super(protocol, S3Config.defaultPort(protocol), vdcs);
    }

    public S3Config(S3Config other) {
        super(other);
        this.useVHost = other.useVHost;
        this.signNamespace = other.signNamespace;
        this.checksumEnabled = other.checksumEnabled;
        this.retryEnabled = other.retryEnabled;
        this.initialRetryDelay = other.initialRetryDelay;
        this.retryLimit = other.retryLimit;
        this.retryBufferSize = other.retryBufferSize;
        this.faultInjectionRate = other.faultInjectionRate;
        this.signMetadataSearch = other.signMetadataSearch;
    }

    @Override
    public Host resolveHost() {
        return this.getVdcs().get(0).getHosts().get(0);
    }

    @ConfigUriProperty
    public boolean isUseVHost() {
        return this.useVHost;
    }

    public void setUseVHost(boolean useVHost) {
        this.useVHost = useVHost;
    }

    @ConfigUriProperty
    public boolean isSignNamespace() {
        return this.signNamespace;
    }

    public void setSignNamespace(boolean signNamespace) {
        this.signNamespace = signNamespace;
    }

    @ConfigUriProperty
    public boolean isChecksumEnabled() {
        return this.checksumEnabled;
    }

    public void setChecksumEnabled(boolean checksumEnabled) {
        this.checksumEnabled = checksumEnabled;
    }

    @ConfigUriProperty
    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public void setRetryEnabled(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
    }

    @ConfigUriProperty
    public int getInitialRetryDelay() {
        return this.initialRetryDelay;
    }

    public void setInitialRetryDelay(int initialRetryDelay) {
        this.initialRetryDelay = initialRetryDelay;
    }

    @ConfigUriProperty
    public int getRetryLimit() {
        return this.retryLimit;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    @ConfigUriProperty
    public int getRetryBufferSize() {
        return this.retryBufferSize;
    }

    public void setRetryBufferSize(int retryBufferSize) {
        this.retryBufferSize = retryBufferSize;
    }

    @ConfigUriProperty
    public float getFaultInjectionRate() {
        return this.faultInjectionRate;
    }

    public void setFaultInjectionRate(float faultInjectionRate) {
        this.faultInjectionRate = faultInjectionRate;
    }

    @ConfigUriProperty
    public boolean isSignMetadataSearch() {
        return this.signMetadataSearch;
    }

    public void setSignMetadataSearch(boolean signMetadataSearch) {
        this.signMetadataSearch = signMetadataSearch;
    }

    public S3Config withUseVHost(boolean useVHost) {
        this.setUseVHost(useVHost);
        return this;
    }

    public S3Config withSignNamespace(boolean signNamespace) {
        this.setSignNamespace(signNamespace);
        return this;
    }

    public S3Config withChecksumEnabled(boolean checksumEnabled) {
        this.setChecksumEnabled(checksumEnabled);
        return this;
    }

    public S3Config withRetryEnabled(boolean retryEnabled) {
        this.setRetryEnabled(retryEnabled);
        return this;
    }

    public S3Config withInitialRetryDelay(int initialRetryDelay) {
        this.setInitialRetryDelay(initialRetryDelay);
        return this;
    }

    public S3Config withRetryLimit(int retryLimit) {
        this.setRetryLimit(retryLimit);
        return this;
    }

    public S3Config withRetryBufferSize(int retryBufferSize) {
        this.setRetryBufferSize(retryBufferSize);
        return this;
    }

    public S3Config withFaultInjectionRate(float faultInjectionRate) {
        this.setFaultInjectionRate(faultInjectionRate);
        return this;
    }

    public S3Config withSignMetadataSearch(boolean signMetadataSearch) {
        this.setSignMetadataSearch(signMetadataSearch);
        return this;
    }

    @Override
    public String toString() {
        return "S3Config{useVHost=" + this.useVHost + ", signNamespace=" + this.signNamespace + ", checksumEnabled=" + this.checksumEnabled + ", retryEnabled=" + this.retryEnabled + ", initialRetryDelay=" + this.initialRetryDelay + ", retryLimit=" + this.retryLimit + ", retryBufferSize=" + this.retryBufferSize + ", faultInjectionRate=" + this.faultInjectionRate + ", signMetadataSearch=" + this.signMetadataSearch + "} " + super.toString();
    }
}

