/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3;

import com.emc.object.util.RestUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class S3ObjectMetadata {
    public static final String EXPIRY_DATE = "expiry-date=";
    public static final String RULE_ID = "rule-id=";
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private Long contentLength;
    private String contentMd5;
    private String contentType;
    private String eTag;
    private Long retentionPeriod;
    private String retentionPolicy;
    private Date expirationDate;
    private String expirationRuleId;
    private Date httpExpires;
    private Date lastModified;
    private String versionId;
    private Map<String, String> userMetadata = new HashMap<String, String>();

    public static <T> S3ObjectMetadata fromHeaders(Map<String, List<T>> headers) {
        S3ObjectMetadata objectMetadata = new S3ObjectMetadata();
        objectMetadata.cacheControl = RestUtil.getFirstAsString(headers, "Cache-Control");
        objectMetadata.contentDisposition = RestUtil.getFirstAsString(headers, "Content-Disposition");
        objectMetadata.contentEncoding = RestUtil.getFirstAsString(headers, "Content-Encoding");
        if (RestUtil.getFirstAsString(headers, "Content-Length") != null) {
            objectMetadata.contentLength = Long.parseLong(RestUtil.getFirstAsString(headers, "Content-Length"));
        }
        objectMetadata.contentMd5 = RestUtil.getFirstAsString(headers, "Content-MD5");
        objectMetadata.contentType = RestUtil.getFirstAsString(headers, "Content-Type");
        objectMetadata.eTag = RestUtil.getFirstAsString(headers, "ETag", true);
        objectMetadata.httpExpires = RestUtil.headerParse(RestUtil.stripQuotes(RestUtil.getFirstAsString(headers, "Expires")));
        String mtime = RestUtil.getFirstAsString(headers, "x-emc-mtime");
        objectMetadata.lastModified = mtime != null && mtime.length() > 0 ? new Date(Long.parseLong(mtime)) : RestUtil.headerParse(RestUtil.getFirstAsString(headers, "Last-Modified"));
        objectMetadata.versionId = RestUtil.getFirstAsString(headers, "x-amz-version-id");
        if (RestUtil.getFirstAsString(headers, "x-emc-retention-period") != null) {
            objectMetadata.retentionPeriod = Long.parseLong(RestUtil.getFirstAsString(headers, "x-emc-retention-period"));
        }
        objectMetadata.retentionPolicy = RestUtil.getFirstAsString(headers, "x-emc-retention-policy");
        objectMetadata.expirationDate = S3ObjectMetadata.getExpirationDate(headers);
        objectMetadata.expirationRuleId = S3ObjectMetadata.getExpirationRuleId(headers);
        objectMetadata.userMetadata = S3ObjectMetadata.getUserMetadata(headers);
        return objectMetadata;
    }

    public static <T> Date getExpirationDate(Map<String, List<T>> headers) {
        List<T> expValues = headers.get("x-amz-expiration");
        if (expValues != null) {
            for (T value : expValues) {
                if (!value.toString().startsWith(EXPIRY_DATE)) continue;
                String expString = value.toString().substring(EXPIRY_DATE.length());
                return RestUtil.headerParse(RestUtil.stripQuotes(expString));
            }
        }
        return null;
    }

    public static <T> String getExpirationRuleId(Map<String, List<T>> headers) {
        List<T> expValues = headers.get("x-amz-expiration");
        if (expValues != null) {
            for (T value : expValues) {
                if (!value.toString().startsWith(RULE_ID)) continue;
                String expString = value.toString().substring(RULE_ID.length());
                return RestUtil.stripQuotes(expString);
            }
        }
        return null;
    }

    public static <T> Map<String, String> getUserMetadata(Map<String, List<T>> headers) {
        HashMap<String, String> userMetadata = new HashMap<String, String>();
        for (String name : headers.keySet()) {
            String key = S3ObjectMetadata.getUserMetadataKey(name);
            if (key == null) continue;
            userMetadata.put(key, RestUtil.getFirstAsString(headers, name));
        }
        return userMetadata;
    }

    protected static String getUserMetadataKey(String headerName) {
        if (headerName.startsWith("x-amz-meta-")) {
            return headerName.substring("x-amz-meta-".length());
        }
        return null;
    }

    public Map<String, List<Object>> toHeaders() {
        HashMap<String, List<Object>> headers = new HashMap<String, List<Object>>();
        RestUtil.putSingle(headers, "Cache-Control", this.cacheControl);
        RestUtil.putSingle(headers, "Content-Disposition", this.contentDisposition);
        RestUtil.putSingle(headers, "Content-Encoding", this.contentEncoding);
        RestUtil.putSingle(headers, "Content-MD5", this.contentMd5);
        RestUtil.putSingle(headers, "Content-Type", this.contentType);
        RestUtil.putSingle(headers, "Expires", RestUtil.headerFormat(this.httpExpires));
        RestUtil.putSingle(headers, "x-emc-retention-period", this.retentionPeriod);
        RestUtil.putSingle(headers, "x-emc-retention-policy", this.retentionPolicy);
        headers.putAll(S3ObjectMetadata.getUmdHeaders(this.userMetadata));
        return headers;
    }

    public static Map<String, List<Object>> getUmdHeaders(Map<String, String> userMetadata) {
        HashMap<String, List<Object>> headers = new HashMap<String, List<Object>>();
        for (String name : userMetadata.keySet()) {
            RestUtil.putSingle(headers, S3ObjectMetadata.getHeaderName(name), userMetadata.get(name));
        }
        return headers;
    }

    public static String getHeaderName(String userMetadataKey) {
        return "x-amz-meta-" + userMetadataKey;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public void setContentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public Long getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public void setRetentionPeriod(Long retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getExpirationRuleId() {
        return this.expirationRuleId;
    }

    public void setExpirationRuleId(String expirationRuleId) {
        this.expirationRuleId = expirationRuleId;
    }

    public Date getHttpExpires() {
        return this.httpExpires;
    }

    public void setHttpExpires(Date httpExpires) {
        this.httpExpires = httpExpires;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata == null ? null : new HashMap<String, String>(userMetadata);
    }

    public String getUserMetadata(String name) {
        return this.userMetadata.get(name);
    }

    public String getDecodedUserMetadata(String name) {
        return RestUtil.urlDecode(this.getUserMetadata(name));
    }

    public S3ObjectMetadata addUserMetadata(String name, String value) {
        this.userMetadata.put(name, value);
        return this;
    }

    public S3ObjectMetadata addEncodedUserMetadata(String name, String value) {
        return this.addUserMetadata(name, RestUtil.urlEncode(value));
    }

    public S3ObjectMetadata withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public S3ObjectMetadata withContentLength(Long contentLength) {
        this.setContentLength(contentLength);
        return this;
    }

    public S3ObjectMetadata withContentLength(int contentLength) {
        return this.withContentLength(Long.valueOf(contentLength));
    }

    public S3ObjectMetadata withContentMd5(String contentMd5) {
        this.setContentMd5(contentMd5);
        return this;
    }

    public S3ObjectMetadata withContentDisposition(String contentDisposition) {
        this.setContentDisposition(contentDisposition);
        return this;
    }

    public S3ObjectMetadata withContentEncoding(String contentEncoding) {
        this.setContentEncoding(contentEncoding);
        return this;
    }

    public S3ObjectMetadata withCacheControl(String cacheControl) {
        this.setCacheControl(cacheControl);
        return this;
    }

    public S3ObjectMetadata withHttpExpires(Date httpExpires) {
        this.setHttpExpires(httpExpires);
        return this;
    }

    public S3ObjectMetadata withRetentionPeriod(Long retentionPeriod) {
        this.setRetentionPeriod(retentionPeriod);
        return this;
    }

    public S3ObjectMetadata withRetentionPolicy(String retentionPolicy) {
        this.setRetentionPolicy(retentionPolicy);
        return this;
    }
}

