/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.codec.CodecChain;
import com.emc.codec.encryption.DoesNotNeedRekeyException;
import com.emc.codec.encryption.EncryptionCodec;
import com.emc.object.EncryptionConfig;
import com.emc.object.s3.S3Config;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.bean.AccessControlList;
import com.emc.object.s3.bean.CompleteMultipartUploadResult;
import com.emc.object.s3.bean.CopyObjectResult;
import com.emc.object.s3.bean.CopyPartResult;
import com.emc.object.s3.bean.GetObjectResult;
import com.emc.object.s3.bean.InitiateMultipartUploadResult;
import com.emc.object.s3.bean.MultipartPartETag;
import com.emc.object.s3.bean.PutObjectResult;
import com.emc.object.s3.jersey.AuthorizationFilter;
import com.emc.object.s3.jersey.CodecFilter;
import com.emc.object.s3.jersey.S3JerseyClient;
import com.emc.object.s3.request.AbortMultipartUploadRequest;
import com.emc.object.s3.request.CompleteMultipartUploadRequest;
import com.emc.object.s3.request.CopyObjectRequest;
import com.emc.object.s3.request.CopyPartRequest;
import com.emc.object.s3.request.GetObjectMetadataRequest;
import com.emc.object.s3.request.GetObjectRequest;
import com.emc.object.s3.request.InitiateMultipartUploadRequest;
import com.emc.object.s3.request.PresignedUrlRequest;
import com.emc.object.s3.request.PutObjectRequest;
import com.emc.object.s3.request.UploadPartRequest;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class S3EncryptionClient
extends S3JerseyClient {
    private static final String UNSUPPORTED_MSG = "This operation is not supported by the encryption client";
    private static final String PARTIAL_UPDATE_MSG = "Partial object updates and/or appends are not supported by the encryption client";
    private static final String PARTIAL_READ_MSG = "Partial object reads are not supported by the encryption client";
    private EncryptionConfig encryptionConfig;

    public S3EncryptionClient(S3Config s3Config, EncryptionConfig encryptionConfig) {
        this(s3Config, null, encryptionConfig);
    }

    public S3EncryptionClient(S3Config s3Config, ClientHandler clientHandler, EncryptionConfig encryptionConfig) {
        super(s3Config, clientHandler);
        this.encryptionConfig = encryptionConfig;
        CodecChain encodeChain = encryptionConfig.isCompressionEnabled() ? new CodecChain(encryptionConfig.getCompressionSpec(), encryptionConfig.getEncryptionSpec()) : new CodecChain(encryptionConfig.getEncryptionSpec());
        encodeChain.setProperties(encryptionConfig.getCodecProperties());
        ArrayList<ClientFilter> filters = new ArrayList<ClientFilter>();
        ClientHandler handler = this.client.getHeadHandler();
        while (handler instanceof ClientFilter) {
            ClientFilter filter = (ClientFilter)handler;
            if (filter instanceof AuthorizationFilter) {
                filters.add(new CodecFilter(encodeChain).withCodecProperties(encryptionConfig.getCodecProperties()));
            }
            filters.add(filter);
            handler = filter.getNext();
        }
        Collections.reverse(filters);
        this.client.removeAllFilters();
        for (ClientFilter filter : filters) {
            this.client.addFilter(filter);
        }
    }

    public boolean rekey(String bucketName, String key) {
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(bucketName, key);
        request.property("com.emc.object.codec.keepEncodeHeaders", Boolean.TRUE);
        S3ObjectMetadata objectMetadata = this.getObjectMetadata(request);
        Map<String, String> userMetadata = objectMetadata.getUserMetadata();
        try {
            new EncryptionCodec().rekey(userMetadata, this.encryptionConfig.getCodecProperties());
            AccessControlList acl = this.getObjectAcl(bucketName, key);
            super.copyObject(new CopyObjectRequest(bucketName, key, bucketName, key).withAcl(acl).withObjectMetadata(objectMetadata));
            return true;
        }
        catch (DoesNotNeedRekeyException e) {
            return false;
        }
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) {
        if (request.getRange() != null) {
            throw new UnsupportedOperationException(PARTIAL_UPDATE_MSG);
        }
        if (request.getObjectMetadata() == null) {
            request.setObjectMetadata(new S3ObjectMetadata());
        }
        Map<String, String> userMeta = request.getObjectMetadata().getUserMetadata();
        request.property("com.emc.object.userMetadata", userMeta);
        request.property("com.emc.object.codec.encodeEntity", Boolean.TRUE);
        PutObjectResult result = super.putObject(request);
        CopyObjectRequest metadataUpdate = new CopyObjectRequest(request.getBucketName(), request.getKey(), request.getBucketName(), request.getKey()).withAcl(request.getAcl()).withObjectMetadata(request.getObjectMetadata()).withIfMatch(result.getETag());
        return super.copyObject(metadataUpdate);
    }

    @Override
    public <T> GetObjectResult<T> getObject(GetObjectRequest request, Class<T> objectType) {
        if (request.getRange() != null) {
            throw new UnsupportedOperationException(PARTIAL_READ_MSG);
        }
        request.property("com.emc.object.codec.decodeEntity", Boolean.TRUE);
        return super.getObject(request, objectType);
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest request) {
        if (request.getObjectMetadata() != null) {
            throw new UnsupportedOperationException("This operation is not supported by the encryption client (copy and replace metadata)");
        }
        return super.copyObject(request);
    }

    @Override
    public URL getPresignedUrl(PresignedUrlRequest request) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void setObjectMetadata(String bucketName, String key, S3ObjectMetadata objectMetadata) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public MultipartPartETag uploadPart(UploadPartRequest request) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest request) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest request) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }
}

