/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.Method;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.bean.AccessControlList;
import com.emc.object.s3.bean.CannedAcl;
import com.emc.object.s3.request.S3ObjectRequest;
import com.emc.object.util.RestUtil;
import java.util.List;
import java.util.Map;

public class InitiateMultipartUploadRequest
extends S3ObjectRequest {
    private S3ObjectMetadata objectMetadata;
    private AccessControlList acl;
    private CannedAcl cannedAcl;

    public InitiateMultipartUploadRequest(String bucketName, String key) {
        super(Method.POST, bucketName, key, "uploads");
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.objectMetadata != null) {
            headers.putAll(this.objectMetadata.toHeaders());
        }
        if (this.acl != null) {
            headers.putAll(this.acl.toHeaders());
        }
        if (this.cannedAcl != null) {
            RestUtil.putSingle(headers, "x-amz-acl", this.cannedAcl.getHeaderValue());
        }
        return headers;
    }

    public S3ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public CannedAcl getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAcl cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public InitiateMultipartUploadRequest withObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.setObjectMetadata(objectMetadata);
        return this;
    }

    public InitiateMultipartUploadRequest withAcl(AccessControlList acl) {
        this.setAcl(acl);
        return this;
    }

    public InitiateMultipartUploadRequest withCannedAcl(CannedAcl cannedAcl) {
        this.setCannedAcl(cannedAcl);
        return this;
    }
}

