/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.PendingReadOp;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ListenerBasedPendingReadOp
extends PendingReadOp {
    private static final Logger log = LoggerFactory.getLogger(ListenerBasedPendingReadOp.class);
    final BookkeeperInternalCallbacks.ReadEntryListener listener;
    final Object ctx;

    ListenerBasedPendingReadOp(LedgerHandle lh, ScheduledExecutorService scheduler, long startEntryId, long endEntryId, BookkeeperInternalCallbacks.ReadEntryListener listener, Object ctx) {
        this(lh, scheduler, startEntryId, endEntryId, listener, ctx, false);
    }

    ListenerBasedPendingReadOp(LedgerHandle lh, ScheduledExecutorService scheduler, long startEntryId, long endEntryId, BookkeeperInternalCallbacks.ReadEntryListener listener, Object ctx, boolean isRecoveryRead) {
        super(lh, scheduler, startEntryId, endEntryId, isRecoveryRead);
        this.listener = listener;
        this.ctx = ctx;
    }

    @Override
    protected void submitCallback(int code) {
        PendingReadOp.LedgerEntryRequest request;
        while (!this.seq.isEmpty() && (request = (PendingReadOp.LedgerEntryRequest)this.seq.get(0)) != null) {
            LedgerEntry entry;
            if (!request.isComplete()) {
                return;
            }
            this.seq.remove(0);
            long latencyNanos = MathUtils.elapsedNanos((long)this.requestTimeNanos);
            if (0 == request.getRc()) {
                this.readOpLogger.registerSuccessfulEvent(latencyNanos, TimeUnit.NANOSECONDS);
                entry = new LedgerEntry(request.entryImpl);
            } else {
                this.readOpLogger.registerFailedEvent(latencyNanos, TimeUnit.NANOSECONDS);
                entry = null;
            }
            request.close();
            this.listener.onEntryComplete(request.getRc(), this.lh, entry, this.ctx);
        }
        this.cancelSpeculativeTask(true);
    }
}

