/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.discover;

import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Evolving
public interface RegistrationManager
extends AutoCloseable {
    @Override
    public void close();

    public String getClusterInstanceId() throws BookieException;

    public void registerBookie(String var1, boolean var2) throws BookieException;

    public void unregisterBookie(String var1, boolean var2) throws BookieException;

    public boolean isBookieRegistered(String var1) throws BookieException;

    public void writeCookie(String var1, Versioned<byte[]> var2) throws BookieException;

    public Versioned<byte[]> readCookie(String var1) throws BookieException;

    public void removeCookie(String var1, Version var2) throws BookieException;

    public boolean prepareFormat() throws Exception;

    public boolean initNewCluster() throws Exception;

    public boolean format() throws Exception;

    public boolean nukeExistingCluster() throws Exception;

    @FunctionalInterface
    public static interface RegistrationListener {
        public void onRegistrationExpired();
    }
}

