/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.attributes;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import io.pravega.segmentstore.storage.SegmentRollingPolicy;

public class AttributeIndexConfig {
    public static final Property<Integer> ATTRIBUTE_SEGMENT_ROLLING_SIZE = Property.named((String)"attributeSegmentRollingSizeBytes", (Object)0x2000000);
    private static final int MAX_INDEX_PAGE_SIZE_VALUE = Short.MAX_VALUE;
    public static final Property<Integer> MAX_INDEX_PAGE_SIZE = Property.named((String)"maxIndexPageSizeBytes", (Object)Short.MAX_VALUE);
    private static final int MIN_INDEX_PAGE_SIZE_VALUE = 1024;
    private static final String COMPONENT_CODE = "attributeindex";
    private final int maxIndexPageSize;
    private final SegmentRollingPolicy attributeSegmentRollingPolicy;

    private AttributeIndexConfig(TypedProperties properties) throws ConfigurationException {
        int rollingSize = properties.getInt(ATTRIBUTE_SEGMENT_ROLLING_SIZE);
        if (rollingSize <= 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a positive integer; found '%d'.", ATTRIBUTE_SEGMENT_ROLLING_SIZE, rollingSize));
        }
        this.attributeSegmentRollingPolicy = new SegmentRollingPolicy((long)rollingSize);
        this.maxIndexPageSize = properties.getInt(MAX_INDEX_PAGE_SIZE);
        if (this.maxIndexPageSize < 1024 || this.maxIndexPageSize > Short.MAX_VALUE) {
            throw new ConfigurationException(String.format("Property '%s' must be at least %s and at most %s; found '%d'.", MAX_INDEX_PAGE_SIZE, 1024, Short.MAX_VALUE, this.maxIndexPageSize));
        }
    }

    public static ConfigBuilder<AttributeIndexConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, AttributeIndexConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    public int getMaxIndexPageSize() {
        return this.maxIndexPageSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public SegmentRollingPolicy getAttributeSegmentRollingPolicy() {
        return this.attributeSegmentRollingPolicy;
    }
}

