/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.attributes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.hash.HashHelper;
import io.pravega.common.util.BitConverter;
import io.pravega.segmentstore.storage.Cache;

class CacheKey
extends Cache.Key {
    private static final HashHelper HASH = HashHelper.seededWith((String)CacheKey.class.getName());
    private static final int SERIALIZATION_LENGTH = 16;
    private final long segmentId;
    private final long offset;

    CacheKey(long segmentId, long offset) {
        Preconditions.checkArgument((segmentId != Long.MIN_VALUE ? 1 : 0) != 0, (Object)"segmentId");
        this.segmentId = segmentId;
        this.offset = offset;
    }

    @VisibleForTesting
    CacheKey(byte[] serialization) {
        Preconditions.checkNotNull((Object)serialization, (Object)"serialization");
        Preconditions.checkArgument((serialization.length == 16 ? 1 : 0) != 0, (Object)"Invalid serialization length.");
        this.segmentId = BitConverter.readLong((byte[])serialization, (int)0);
        this.offset = BitConverter.readLong((byte[])serialization, (int)8);
    }

    public byte[] serialize() {
        byte[] result = new byte[16];
        BitConverter.writeLong((byte[])result, (int)0, (long)this.segmentId);
        BitConverter.writeLong((byte[])result, (int)8, (long)this.offset);
        return result;
    }

    public int hashCode() {
        return HASH.hash(this.offset);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CacheKey)) {
            return false;
        }
        CacheKey other = (CacheKey)((Object)obj);
        return this.segmentId == other.segmentId && this.offset == other.offset;
    }

    public String toString() {
        return String.format("SegmentId = %d, Offset = %d", this.segmentId, this.offset);
    }

    @SuppressFBWarnings(justification="generated code")
    public long getSegmentId() {
        return this.segmentId;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getOffset() {
        return this.offset;
    }
}

