/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.attributes;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.server.AttributeIndex;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.ContainerMetadata;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.attributes.AttributeIndexConfig;
import io.pravega.segmentstore.server.attributes.ContainerAttributeIndex;
import io.pravega.segmentstore.server.attributes.SegmentAttributeBTreeIndex;
import io.pravega.segmentstore.storage.Cache;
import io.pravega.segmentstore.storage.CacheFactory;
import io.pravega.segmentstore.storage.Storage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContainerAttributeIndexImpl
implements ContainerAttributeIndex {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ContainerAttributeIndexImpl.class);
    private final ContainerMetadata containerMetadata;
    private final Storage storage;
    private final AttributeIndexConfig config;
    private final Cache cache;
    private final CacheManager cacheManager;
    @GuardedBy(value="attributeIndices")
    private final HashMap<Long, CompletableFuture<AttributeIndex>> attributeIndices;
    private final ScheduledExecutorService executor;
    private final String traceObjectId;
    private final AtomicBoolean closed;

    ContainerAttributeIndexImpl(ContainerMetadata containerMetadata, Storage storage, CacheFactory cacheFactory, CacheManager cacheManager, AttributeIndexConfig config, ScheduledExecutorService executor) {
        this.containerMetadata = (ContainerMetadata)Preconditions.checkNotNull((Object)containerMetadata, (Object)"containerMetadata");
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage, (Object)"storage");
        this.cache = cacheFactory.getCache(String.format("Container_%d_Attributes", containerMetadata.getContainerId()));
        this.cacheManager = (CacheManager)Preconditions.checkNotNull((Object)cacheManager, (Object)"cacheManager");
        this.config = (AttributeIndexConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.attributeIndices = new HashMap();
        this.traceObjectId = String.format("ContainerAttributeIndex[%d]", containerMetadata.getContainerId());
        this.closed = new AtomicBoolean();
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.closeIndices(null, false);
            this.cache.close();
            log.info("{}: Closed.", (Object)this.traceObjectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AttributeIndex> forSegment(long streamSegmentId, Duration timeout) {
        CompletableFuture result;
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        SegmentMetadata sm = this.containerMetadata.getStreamSegmentMetadata(streamSegmentId);
        if (sm.isDeleted()) {
            return Futures.failedFuture((Throwable)new StreamSegmentNotExistsException(sm.getName()));
        }
        AtomicReference toInitialize = new AtomicReference();
        HashMap<Long, CompletableFuture<AttributeIndex>> hashMap = this.attributeIndices;
        synchronized (hashMap) {
            result = this.attributeIndices.computeIfAbsent(streamSegmentId, id -> {
                toInitialize.set(new SegmentAttributeBTreeIndex(sm, this.storage, this.cache, this.config, this.executor));
                return new CompletableFuture();
            });
        }
        if (toInitialize.get() == null) {
            return result;
        }
        try {
            ((CompletableFuture)((SegmentAttributeBTreeIndex)toInitialize.get()).initialize(timeout).thenRun(() -> this.cacheManager.register((CacheManager.Client)toInitialize.get()))).whenComplete((r, ex) -> {
                if (ex == null) {
                    result.complete(toInitialize.get());
                } else {
                    this.indexInitializationFailed(streamSegmentId, result, (Throwable)ex);
                }
            });
        }
        catch (Throwable ex2) {
            if (!Exceptions.mustRethrow((Throwable)ex2)) {
                this.indexInitializationFailed(streamSegmentId, result, ex2);
            }
            throw ex2;
        }
        return result;
    }

    @Override
    public CompletableFuture<Void> delete(String segmentName, Duration timeout) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return SegmentAttributeBTreeIndex.delete(segmentName, this.storage, timeout);
    }

    @Override
    public void cleanup(Collection<Long> segmentIds) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.closeIndices(segmentIds, true);
        log.info("{}: Cleaned up Attribute Indices for {} Segment(s).", (Object)this.traceObjectId, segmentIds == null ? "all" : Integer.valueOf(segmentIds.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexInitializationFailed(long streamSegmentId, CompletableFuture<AttributeIndex> result, Throwable ex) {
        HashMap<Long, CompletableFuture<AttributeIndex>> hashMap = this.attributeIndices;
        synchronized (hashMap) {
            this.attributeIndices.remove(streamSegmentId);
        }
        result.completeExceptionally(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIndices(Collection<Long> segmentIds, boolean cleanCache) {
        HashMap<Long, CompletableFuture<AttributeIndex>> hashMap = this.attributeIndices;
        synchronized (hashMap) {
            if (segmentIds == null) {
                segmentIds = new ArrayList<Long>(this.attributeIndices.keySet());
            }
            for (long streamSegmentId : segmentIds) {
                CompletableFuture<AttributeIndex> indexFuture = this.attributeIndices.remove(streamSegmentId);
                if (indexFuture == null) continue;
                if (Futures.isSuccessful(indexFuture)) {
                    this.closeIndex((SegmentAttributeBTreeIndex)indexFuture.join(), cleanCache);
                    continue;
                }
                indexFuture.thenAcceptAsync(index -> this.closeIndex((SegmentAttributeBTreeIndex)index, cleanCache), (Executor)this.executor);
            }
        }
    }

    private void closeIndex(SegmentAttributeBTreeIndex ai, boolean cleanCache) {
        this.cacheManager.unregister(ai);
        ai.close(cleanCache);
    }
}

