/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.io.SerializationException;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ArrayView;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentInformation;
import io.pravega.segmentstore.contracts.StreamSegmentMergedException;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.TooManyActiveSegmentsException;
import io.pravega.segmentstore.server.ContainerMetadata;
import io.pravega.segmentstore.server.DataCorruptionException;
import io.pravega.segmentstore.server.SegmentMetadata;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class MetadataStore
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(MetadataStore.class);
    protected final String traceObjectId;
    protected final Executor executor;
    private final Connector connector;
    @GuardedBy(value="pendingRequests")
    private final HashMap<String, PendingRequest> pendingRequests;

    MetadataStore(@NonNull Connector connector, @NonNull Executor executor) {
        if (connector == null) {
            throw new NullPointerException("connector is marked @NonNull but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked @NonNull but is null");
        }
        this.traceObjectId = String.format("MetadataStore[%d]", connector.containerMetadata.getContainerId());
        this.connector = connector;
        this.executor = executor;
        this.pendingRequests = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<PendingRequest> toCancel;
        HashMap<String, PendingRequest> hashMap = this.pendingRequests;
        synchronized (hashMap) {
            toCancel = new ArrayList<PendingRequest>(this.pendingRequests.values());
            this.pendingRequests.clear();
        }
        ObjectClosedException ex = new ObjectClosedException((Object)this);
        toCancel.forEach(r -> r.completeExceptionally(ex));
    }

    abstract CompletableFuture<Void> initialize(Duration var1);

    CompletableFuture<Void> createSegment(String segmentName, Collection<AttributeUpdate> attributes, Duration timeout) {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"createSegment", (Object[])new Object[]{segmentName});
        long segmentId = this.connector.containerMetadata.getStreamSegmentId(segmentName, true);
        if (this.isValidSegmentId(segmentId)) {
            return Futures.failedFuture((Throwable)new StreamSegmentExistsException(segmentName));
        }
        ArrayView segmentInfo = SegmentInfo.serialize(SegmentInfo.newSegment(segmentName, attributes));
        CompletableFuture<Void> result = this.createSegment(segmentName, segmentInfo, new TimeoutTimer(timeout));
        if (log.isTraceEnabled()) {
            result.thenAccept(v -> LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"createSegment", (long)traceId, (Object[])new Object[]{segmentName}));
        }
        return result;
    }

    protected abstract CompletableFuture<Void> createSegment(String var1, ArrayView var2, TimeoutTimer var3);

    CompletableFuture<Boolean> deleteSegment(String segmentName, Duration timeout) {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"deleteSegment", (Object[])new Object[]{segmentName});
        TimeoutTimer timer = new TimeoutTimer(timeout);
        long segmentId = this.connector.containerMetadata.getStreamSegmentId(segmentName, true);
        CompletableFuture<Object> deleteSegment = this.isValidSegmentId(segmentId) ? (this.connector.containerMetadata.getStreamSegmentMetadata(segmentId).isDeleted() ? CompletableFuture.completedFuture(null) : this.connector.getLazyDeleteSegment().apply(segmentId, timer.getRemaining())) : this.connector.getDirectDeleteSegment().apply(segmentName, timer.getRemaining());
        CompletionStage result = Futures.exceptionallyExpecting(deleteSegment, ex -> ex instanceof StreamSegmentNotExistsException, null).thenComposeAsync(ignored -> this.clearSegmentInfo(segmentName, timer.getRemaining()), this.executor);
        if (log.isTraceEnabled()) {
            deleteSegment.thenAccept(v -> LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"deleteSegment", (long)traceId, (Object[])new Object[]{segmentName}));
        }
        return result;
    }

    public abstract CompletableFuture<Boolean> clearSegmentInfo(String var1, Duration var2);

    CompletableFuture<SegmentProperties> getSegmentInfo(String segmentName, Duration timeout) {
        QueuedCallback queuedCallback;
        long streamSegmentId = this.connector.containerMetadata.getStreamSegmentId(segmentName, true);
        CompletionStage<Object> result = this.isValidSegmentId(streamSegmentId) ? this.getSegmentSnapshot(streamSegmentId, segmentName) : ((queuedCallback = this.checkConcurrentAssignment(segmentName, id -> this.getSegmentSnapshot((long)id, segmentName))) != null ? queuedCallback.result : this.getSegmentInfoInternal(segmentName, timeout).thenApply(rawData -> SegmentInfo.deserialize(rawData).getProperties()));
        return result;
    }

    private CompletableFuture<SegmentProperties> getSegmentSnapshot(long segmentId, String segmentName) {
        SegmentMetadata sm = this.connector.containerMetadata.getStreamSegmentMetadata(segmentId);
        if (sm == null || sm.isDeleted() || sm.isMerged()) {
            return Futures.failedFuture((Throwable)new StreamSegmentNotExistsException(segmentName));
        }
        return CompletableFuture.completedFuture(sm.getSnapshot());
    }

    protected abstract CompletableFuture<ArrayView> getSegmentInfoInternal(String var1, Duration var2);

    CompletableFuture<Void> updateSegmentInfo(SegmentMetadata segmentMetadata, Duration timeout) {
        if (segmentMetadata.isMerged()) {
            return Futures.failedFuture((Throwable)new StreamSegmentMergedException(segmentMetadata.getName()));
        }
        if (segmentMetadata.isDeleted()) {
            return Futures.failedFuture((Throwable)new StreamSegmentNotExistsException(segmentMetadata.getName()));
        }
        ArrayView toWrite = SegmentInfo.serialize(new SegmentInfo(segmentMetadata.getId(), segmentMetadata.getSnapshot()));
        return this.updateSegmentInfo(segmentMetadata.getName(), toWrite, timeout);
    }

    protected abstract CompletableFuture<Void> updateSegmentInfo(String var1, ArrayView var2, Duration var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> CompletableFuture<T> getOrAssignSegmentId(String segmentName, Duration timeout, @NonNull Function<Long, CompletableFuture<T>> thenCompose) {
        QueuedCallback<T> queuedCallback;
        if (thenCompose == null) {
            throw new NullPointerException("thenCompose is marked @NonNull but is null");
        }
        long segmentId = this.connector.containerMetadata.getStreamSegmentId(segmentName, true);
        if (this.isValidSegmentId(segmentId)) {
            if (this.connector.containerMetadata.getStreamSegmentMetadata(segmentId).isDeleted()) {
                return Futures.failedFuture((Throwable)new StreamSegmentNotExistsException(segmentName));
            }
            QueuedCallback<T> queuedCallback2 = this.checkConcurrentAssignment(segmentName, thenCompose);
            return queuedCallback2 == null ? thenCompose.apply(segmentId) : queuedCallback2.result;
        }
        boolean needsAssignment = false;
        HashMap<String, PendingRequest> hashMap = this.pendingRequests;
        synchronized (hashMap) {
            PendingRequest pendingRequest = this.pendingRequests.getOrDefault(segmentName, null);
            if (pendingRequest == null) {
                needsAssignment = true;
                pendingRequest = new PendingRequest();
                this.pendingRequests.put(segmentName, pendingRequest);
            }
            queuedCallback = new QueuedCallback<T>(thenCompose);
            pendingRequest.callbacks.add(queuedCallback);
        }
        if (needsAssignment) {
            this.executor.execute(() -> this.assignSegmentId(segmentName, timeout));
        }
        return queuedCallback.result;
    }

    @VisibleForTesting
    CompletableFuture<Long> getOrAssignSegmentId(String streamSegmentName, Duration timeout) {
        return this.getOrAssignSegmentId(streamSegmentName, timeout, CompletableFuture::completedFuture);
    }

    private void assignSegmentId(String segmentName, Duration timeout) {
        try {
            TimeoutTimer timer = new TimeoutTimer(timeout);
            Futures.exceptionListener((CompletableFuture)this.getSegmentInfoInternal(segmentName, timer.getRemaining()).thenComposeAsync(si -> this.submitAssignmentWithRetry(SegmentInfo.deserialize(si), timer.getRemaining()), this.executor), ex -> this.failAssignment(segmentName, (Throwable)ex));
        }
        catch (Throwable ex2) {
            log.warn("{}: Unable to assign Id for segment '{}'.", new Object[]{this.traceObjectId, segmentName, ex2});
            this.failAssignment(segmentName, ex2);
        }
    }

    private CompletableFuture<Long> submitAssignmentWithRetry(SegmentInfo segmentInfo, Duration timeout) {
        return this.retryWithCleanup(() -> this.submitAssignment(segmentInfo, false, timeout));
    }

    protected CompletableFuture<Long> submitAssignment(SegmentInfo segmentInfo, boolean pin, Duration timeout) {
        SegmentProperties properties = segmentInfo.getProperties();
        if (properties.isDeleted()) {
            this.failAssignment(properties.getName(), new StreamSegmentNotExistsException("StreamSegment does not exist."));
            return Futures.failedFuture((Throwable)new StreamSegmentNotExistsException(properties.getName()));
        }
        long existingSegmentId = this.connector.containerMetadata.getStreamSegmentId(properties.getName(), true);
        if (this.isValidSegmentId(existingSegmentId)) {
            this.completeAssignment(properties.getName(), existingSegmentId);
            return CompletableFuture.completedFuture(existingSegmentId);
        }
        return this.connector.getMapSegmentId().apply(segmentInfo.getSegmentId(), segmentInfo.getProperties(), pin, timeout).thenApply(id -> this.completeAssignment(properties.getName(), (long)id));
    }

    private long completeAssignment(String streamSegmentName, long streamSegmentId) {
        assert (streamSegmentId != Long.MIN_VALUE) : "no valid streamSegmentId given";
        this.finishPendingRequests(streamSegmentName, PendingRequest::complete, streamSegmentId, true);
        return streamSegmentId;
    }

    private void failAssignment(String streamSegmentName, Throwable reason) {
        this.finishPendingRequests(streamSegmentName, PendingRequest::completeExceptionally, reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void finishPendingRequests(String streamSegmentName, BiConsumer<PendingRequest, T> completionMethod, T completionArgument, boolean isSuccess) {
        assert (streamSegmentName != null) : "no streamSegmentName given";
        do {
            PendingRequest pendingRequest;
            HashMap<String, PendingRequest> hashMap = this.pendingRequests;
            synchronized (hashMap) {
                pendingRequest = this.pendingRequests.remove(streamSegmentName);
                if (pendingRequest == null || pendingRequest.callbacks.size() == 0) {
                    break;
                }
                if (isSuccess) {
                    this.pendingRequests.put(streamSegmentName, new PendingRequest());
                }
            }
            completionMethod.accept(pendingRequest, (PendingRequest)completionArgument);
        } while (isSuccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> QueuedCallback<T> checkConcurrentAssignment(String segmentName, Function<Long, CompletableFuture<T>> thenCompose) {
        QueuedCallback<T> queuedCallback = null;
        HashMap<String, PendingRequest> hashMap = this.pendingRequests;
        synchronized (hashMap) {
            PendingRequest pendingRequest = this.pendingRequests.getOrDefault(segmentName, null);
            if (pendingRequest != null) {
                queuedCallback = new QueuedCallback<T>(thenCompose);
                pendingRequest.callbacks.add(queuedCallback);
            }
        }
        return queuedCallback;
    }

    private boolean isValidSegmentId(long id) {
        return id != Long.MIN_VALUE;
    }

    private <T> CompletableFuture<T> retryWithCleanup(Supplier<CompletableFuture<T>> toTry) {
        CompletableFuture result = new CompletableFuture();
        ((CompletableFuture)toTry.get().thenAccept(result::complete)).exceptionally(ex -> {
            try {
                if (Exceptions.unwrap((Throwable)ex) instanceof TooManyActiveSegmentsException) {
                    log.debug("{}: Forcing metadata cleanup due to capacity exceeded ({}).", (Object)this.traceObjectId, (Object)Exceptions.unwrap((Throwable)ex).getMessage());
                    CompletionStage f = this.connector.getMetadataCleanup().get().thenComposeAsync(arg_0 -> MetadataStore.lambda$null$12((Supplier)toTry, arg_0), this.executor);
                    ((CompletableFuture)f).thenAccept(result::complete);
                    Futures.exceptionListener((CompletableFuture)f, result::completeExceptionally);
                } else {
                    result.completeExceptionally((Throwable)ex);
                }
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
                throw t;
            }
            return null;
        });
        return result;
    }

    private static /* synthetic */ CompletionStage lambda$null$12(Supplier toTry, Void v) {
        return (CompletableFuture)toTry.get();
    }

    protected static class SegmentInfo {
        private static final SegmentInfoSerializer SERIALIZER = new SegmentInfoSerializer();
        private final long segmentId;
        private final SegmentProperties properties;

        static SegmentInfo newSegment(String name, Collection<AttributeUpdate> attributeUpdates) {
            StreamSegmentInformation.StreamSegmentInformationBuilder infoBuilder = StreamSegmentInformation.builder().name(name);
            if (attributeUpdates != null) {
                infoBuilder.attributes(attributeUpdates.stream().collect(Collectors.toMap(AttributeUpdate::getAttributeId, AttributeUpdate::getValue)));
            }
            return SegmentInfo.builder().segmentId(Long.MIN_VALUE).properties((SegmentProperties)infoBuilder.build()).build();
        }

        static ArrayView serialize(SegmentInfo state) {
            return SERIALIZER.serialize(state);
        }

        static SegmentInfo deserialize(ArrayView contents) {
            try {
                return (SegmentInfo)SERIALIZER.deserialize(contents);
            }
            catch (SerializationException | EOFException ex) {
                throw new CompletionException((Throwable)((Object)new DataCorruptionException("Unable to deserialize Segment Info.", ex, new Object[0])));
            }
        }

        @ConstructorProperties(value={"segmentId", "properties"})
        @SuppressFBWarnings(justification="generated code")
        SegmentInfo(long segmentId, SegmentProperties properties) {
            this.segmentId = segmentId;
            this.properties = properties;
        }

        @SuppressFBWarnings(justification="generated code")
        public static SegmentInfoBuilder builder() {
            return new SegmentInfoBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public long getSegmentId() {
            return this.segmentId;
        }

        @SuppressFBWarnings(justification="generated code")
        public SegmentProperties getProperties() {
            return this.properties;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentInfo)) {
                return false;
            }
            SegmentInfo other = (SegmentInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSegmentId() != other.getSegmentId()) {
                return false;
            }
            SegmentProperties this$properties = this.getProperties();
            SegmentProperties other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof SegmentInfo;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $segmentId = this.getSegmentId();
            result = result * 59 + (int)($segmentId >>> 32 ^ $segmentId);
            SegmentProperties $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "MetadataStore.SegmentInfo(segmentId=" + this.getSegmentId() + ", properties=" + this.getProperties() + ")";
        }

        private static class SegmentInfoSerializer
        extends VersionedSerializer.WithBuilder<SegmentInfo, SegmentInfoBuilder> {
            private SegmentInfoSerializer() {
            }

            protected SegmentInfoBuilder newBuilder() {
                return SegmentInfo.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void write00(SegmentInfo s, RevisionDataOutput output) throws IOException {
                output.writeLong(s.getSegmentId());
                SegmentProperties sp = s.getProperties();
                output.writeUTF(sp.getName());
                output.writeLong(sp.getLength());
                output.writeLong(sp.getStartOffset());
                output.writeBoolean(sp.isSealed());
                output.writeMap(Attributes.getCoreNonNullAttributes((Map)sp.getAttributes()), RevisionDataOutput::writeUUID, DataOutput::writeLong);
            }

            private void read00(RevisionDataInput input, SegmentInfoBuilder builder) throws IOException {
                builder.segmentId(input.readLong());
                StreamSegmentInformation.StreamSegmentInformationBuilder infoBuilder = StreamSegmentInformation.builder().name(input.readUTF()).length(input.readLong()).startOffset(input.readLong()).sealed(input.readBoolean());
                infoBuilder.attributes(input.readMap(RevisionDataInput::readUUID, DataInput::readLong));
                builder.properties((SegmentProperties)infoBuilder.build());
            }
        }

        static class SegmentInfoBuilder
        implements ObjectBuilder<SegmentInfo> {
            @SuppressFBWarnings(justification="generated code")
            private long segmentId;
            @SuppressFBWarnings(justification="generated code")
            private SegmentProperties properties;

            @SuppressFBWarnings(justification="generated code")
            SegmentInfoBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public SegmentInfoBuilder segmentId(long segmentId) {
                this.segmentId = segmentId;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public SegmentInfoBuilder properties(SegmentProperties properties) {
                this.properties = properties;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public SegmentInfo build() {
                return new SegmentInfo(this.segmentId, this.properties);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "MetadataStore.SegmentInfo.SegmentInfoBuilder(segmentId=" + this.segmentId + ", properties=" + this.properties + ")";
            }
        }
    }

    private static class QueuedCallback<T> {
        final CompletableFuture<T> result = new CompletableFuture();
        final Function<Long, CompletableFuture<T>> callback;

        void complete(long segmentId) {
            Futures.completeAfter(() -> this.callback.apply(segmentId), this.result);
        }

        void completeExceptionally(Throwable ex) {
            this.result.completeExceptionally(ex);
        }

        @ConstructorProperties(value={"callback"})
        @SuppressFBWarnings(justification="generated code")
        public QueuedCallback(Function<Long, CompletableFuture<T>> callback) {
            this.callback = callback;
        }
    }

    @NotThreadSafe
    private static class PendingRequest {
        private final ArrayList<QueuedCallback<?>> callbacks = new ArrayList();

        private PendingRequest() {
        }

        void complete(long segmentId) {
            for (QueuedCallback<?> callback : this.callbacks) {
                try {
                    callback.complete(segmentId);
                }
                catch (Throwable ex) {
                    callback.completeExceptionally(ex);
                }
            }
        }

        void completeExceptionally(Throwable ex) {
            for (QueuedCallback<?> callback : this.callbacks) {
                callback.completeExceptionally(ex);
            }
        }
    }

    static class Connector {
        @NonNull
        private final ContainerMetadata containerMetadata;
        @NonNull
        private final MapSegmentId mapSegmentId;
        @NonNull
        private final DirectDeleteSegment directDeleteSegment;
        @NonNull
        private final LazyDeleteSegment lazyDeleteSegment;
        @NonNull
        private Supplier<CompletableFuture<Void>> metadataCleanup;

        @ConstructorProperties(value={"containerMetadata", "mapSegmentId", "directDeleteSegment", "lazyDeleteSegment", "metadataCleanup"})
        @SuppressFBWarnings(justification="generated code")
        public Connector(@NonNull ContainerMetadata containerMetadata, @NonNull MapSegmentId mapSegmentId, @NonNull DirectDeleteSegment directDeleteSegment, @NonNull LazyDeleteSegment lazyDeleteSegment, @NonNull Supplier<CompletableFuture<Void>> metadataCleanup) {
            if (containerMetadata == null) {
                throw new NullPointerException("containerMetadata is marked @NonNull but is null");
            }
            if (mapSegmentId == null) {
                throw new NullPointerException("mapSegmentId is marked @NonNull but is null");
            }
            if (directDeleteSegment == null) {
                throw new NullPointerException("directDeleteSegment is marked @NonNull but is null");
            }
            if (lazyDeleteSegment == null) {
                throw new NullPointerException("lazyDeleteSegment is marked @NonNull but is null");
            }
            if (metadataCleanup == null) {
                throw new NullPointerException("metadataCleanup is marked @NonNull but is null");
            }
            this.containerMetadata = containerMetadata;
            this.mapSegmentId = mapSegmentId;
            this.directDeleteSegment = directDeleteSegment;
            this.lazyDeleteSegment = lazyDeleteSegment;
            this.metadataCleanup = metadataCleanup;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public ContainerMetadata getContainerMetadata() {
            return this.containerMetadata;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public MapSegmentId getMapSegmentId() {
            return this.mapSegmentId;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public DirectDeleteSegment getDirectDeleteSegment() {
            return this.directDeleteSegment;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public LazyDeleteSegment getLazyDeleteSegment() {
            return this.lazyDeleteSegment;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public Supplier<CompletableFuture<Void>> getMetadataCleanup() {
            return this.metadataCleanup;
        }

        @FunctionalInterface
        public static interface LazyDeleteSegment {
            public CompletableFuture<Void> apply(long var1, Duration var3);
        }

        @FunctionalInterface
        public static interface DirectDeleteSegment {
            public CompletableFuture<Void> apply(String var1, Duration var2);
        }

        @FunctionalInterface
        public static interface MapSegmentId {
            public CompletableFuture<Long> apply(long var1, SegmentProperties var3, boolean var4, Duration var5);
        }
    }
}

