/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.server.OperationLogFactory;
import io.pravega.segmentstore.server.ReadIndexFactory;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentContainerFactory;
import io.pravega.segmentstore.server.WriterFactory;
import io.pravega.segmentstore.server.attributes.AttributeIndexFactory;
import io.pravega.segmentstore.server.containers.ContainerConfig;
import io.pravega.segmentstore.server.containers.StreamSegmentContainer;
import io.pravega.segmentstore.storage.StorageFactory;
import java.util.concurrent.ScheduledExecutorService;

public class StreamSegmentContainerFactory
implements SegmentContainerFactory {
    private final ContainerConfig config;
    private final OperationLogFactory operationLogFactory;
    private final ReadIndexFactory readIndexFactory;
    private final AttributeIndexFactory attributeIndexFactory;
    private final WriterFactory writerFactory;
    private final StorageFactory storageFactory;
    private final SegmentContainerFactory.CreateExtensions createExtensions;
    private final ScheduledExecutorService executor;

    public StreamSegmentContainerFactory(ContainerConfig config, OperationLogFactory operationLogFactory, ReadIndexFactory readIndexFactory, AttributeIndexFactory attributeIndexFactory, WriterFactory writerFactory, StorageFactory storageFactory, SegmentContainerFactory.CreateExtensions createExtensions, ScheduledExecutorService executor) {
        this.config = (ContainerConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.operationLogFactory = (OperationLogFactory)Preconditions.checkNotNull((Object)operationLogFactory, (Object)"operationLogFactory");
        this.readIndexFactory = (ReadIndexFactory)Preconditions.checkNotNull((Object)readIndexFactory, (Object)"readIndexFactory");
        this.attributeIndexFactory = (AttributeIndexFactory)Preconditions.checkNotNull((Object)attributeIndexFactory, (Object)"attributeIndexFactory");
        this.writerFactory = (WriterFactory)Preconditions.checkNotNull((Object)writerFactory, (Object)"writerFactory");
        this.storageFactory = (StorageFactory)Preconditions.checkNotNull((Object)storageFactory, (Object)"storageFactory");
        this.createExtensions = (SegmentContainerFactory.CreateExtensions)Preconditions.checkNotNull((Object)createExtensions, (Object)"createExtensions");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    @Override
    public SegmentContainer createStreamSegmentContainer(int containerId) {
        return new StreamSegmentContainer(containerId, this.config, this.operationLogFactory, this.readIndexFactory, this.attributeIndexFactory, this.writerFactory, this.storageFactory, this.createExtensions, this.executor);
    }
}

