/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.server.EvictableMetadata;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.SegmentStoreMetrics;
import io.pravega.segmentstore.server.UpdateableContainerMetadata;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.containers.StreamSegmentMetadata;
import io.pravega.segmentstore.storage.LogAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
@ThreadSafe
public class StreamSegmentContainerMetadata
implements UpdateableContainerMetadata,
EvictableMetadata {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamSegmentContainerMetadata.class);
    private static final long NO_EPOCH = Long.MIN_VALUE;
    private final String traceObjectId;
    private final AtomicLong sequenceNumber;
    private final AtomicLong lastTruncatedSequenceNumber;
    private final AtomicLong epoch;
    @GuardedBy(value="lock")
    private final HashMap<String, StreamSegmentMetadata> metadataByName;
    @GuardedBy(value="lock")
    private final HashMap<Long, StreamSegmentMetadata> metadataById;
    private final AtomicBoolean recoveryMode;
    private final int streamSegmentContainerId;
    private final int maxActiveSegmentCount;
    @GuardedBy(value="truncationMarkers")
    private final TreeMap<Long, LogAddress> truncationMarkers;
    @GuardedBy(value="truncationMarkers")
    private final TreeSet<Long> truncationPoints;
    private final Object lock = new Object();
    private final SegmentStoreMetrics.Metadata metrics;

    public StreamSegmentContainerMetadata(int streamSegmentContainerId, int maxActiveSegmentCount) {
        Preconditions.checkArgument((maxActiveSegmentCount > 0 ? 1 : 0) != 0, (Object)"maxActiveSegmentCount must be a positive integer.");
        this.traceObjectId = String.format("SegmentContainer[%d]", streamSegmentContainerId);
        this.streamSegmentContainerId = streamSegmentContainerId;
        this.maxActiveSegmentCount = maxActiveSegmentCount;
        this.sequenceNumber = new AtomicLong();
        this.metadataByName = new HashMap();
        this.metadataById = new HashMap();
        this.truncationMarkers = new TreeMap();
        this.truncationPoints = new TreeSet();
        this.recoveryMode = new AtomicBoolean();
        this.lastTruncatedSequenceNumber = new AtomicLong();
        this.epoch = new AtomicLong(Long.MIN_VALUE);
        this.metrics = new SegmentStoreMetrics.Metadata(this.streamSegmentContainerId);
        this.metrics.segmentCount(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getStreamSegmentId(String streamSegmentName, boolean updateLastUsed) {
        Object object = this.lock;
        synchronized (object) {
            StreamSegmentMetadata metadata = this.metadataByName.getOrDefault(streamSegmentName, null);
            if (updateLastUsed && metadata != null) {
                metadata.setLastUsed(this.getOperationSequenceNumber());
            }
            return metadata != null ? metadata.getId() : Long.MIN_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateableSegmentMetadata getStreamSegmentMetadata(long streamSegmentId) {
        Object object = this.lock;
        synchronized (object) {
            return this.metadataById.getOrDefault(streamSegmentId, null);
        }
    }

    @Override
    public int getContainerId() {
        return this.streamSegmentContainerId;
    }

    @Override
    public long getContainerEpoch() {
        return this.epoch.get();
    }

    @Override
    public boolean isRecoveryMode() {
        return this.recoveryMode.get();
    }

    @Override
    public long getOperationSequenceNumber() {
        return this.sequenceNumber.get();
    }

    @Override
    public int getMaximumActiveSegmentCount() {
        return this.maxActiveSegmentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveSegmentCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.metadataById.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateableSegmentMetadata mapStreamSegmentId(String streamSegmentName, long streamSegmentId) {
        int count;
        StreamSegmentMetadata segmentMetadata;
        Object object = this.lock;
        synchronized (object) {
            Exceptions.checkArgument((!this.metadataByName.containsKey(streamSegmentName) ? 1 : 0) != 0, (String)"streamSegmentName", (String)"StreamSegment '%s' is already mapped.", (Object[])new Object[]{streamSegmentName});
            Exceptions.checkArgument((!this.metadataById.containsKey(streamSegmentId) ? 1 : 0) != 0, (String)"streamSegmentId", (String)"StreamSegment Id %d is already mapped.", (Object[])new Object[]{streamSegmentId});
            if (!this.recoveryMode.get()) {
                Preconditions.checkState((this.metadataById.size() < this.maxActiveSegmentCount ? 1 : 0) != 0, (String)"StreamSegment '%s' cannot be mapped because the maximum allowed number of mapped segments (%s)has been reached.", (Object)streamSegmentName, (int)this.maxActiveSegmentCount);
            }
            segmentMetadata = new StreamSegmentMetadata(streamSegmentName, streamSegmentId, this.getContainerId());
            this.metadataByName.put(streamSegmentName, segmentMetadata);
            this.metadataById.put(streamSegmentId, segmentMetadata);
            count = this.metadataById.size();
        }
        segmentMetadata.setLastUsed(this.getOperationSequenceNumber());
        log.info("{}: MapStreamSegment SegmentId = {}, Name = '{}', Active = {}", new Object[]{this.traceObjectId, streamSegmentId, streamSegmentName, count});
        this.metrics.segmentCount(count);
        return segmentMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> getAllStreamSegmentIds() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<Long>(this.metadataById.keySet());
        }
    }

    @Override
    public long nextOperationSequenceNumber() {
        this.ensureNonRecoveryMode();
        return this.sequenceNumber.incrementAndGet();
    }

    @Override
    public void setOperationSequenceNumber(long value) {
        this.ensureRecoveryMode();
        Exceptions.checkArgument((value >= this.sequenceNumber.get() ? 1 : 0) != 0, (String)"value", (String)"Invalid SequenceNumber. Expecting greater than %d.", (Object[])new Object[]{this.sequenceNumber.get()});
        this.sequenceNumber.set(value);
    }

    @Override
    public void setContainerEpoch(long value) {
        this.ensureRecoveryMode();
        Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (Object)"epoch must be a non-negative number");
        Preconditions.checkState((boolean)this.epoch.compareAndSet(Long.MIN_VALUE, value), (Object)"epoch has already been set.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SegmentMetadata> getEvictionCandidates(long sequenceNumberCutoff, int maxCount) {
        List<SegmentMetadata> candidates;
        long adjustedCutoff = Math.min(sequenceNumberCutoff, this.lastTruncatedSequenceNumber.get());
        Object object = this.lock;
        synchronized (object) {
            candidates = this.metadataById.values().stream().filter(m -> this.isEligibleForEviction((SegmentMetadata)m, adjustedCutoff)).collect(Collectors.toList());
        }
        if (candidates.size() > maxCount) {
            candidates.sort(Comparator.comparingLong(SegmentMetadata::getLastUsed));
            candidates = candidates.subList(0, maxCount);
        }
        return candidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SegmentMetadata> cleanup(Collection<SegmentMetadata> evictionCandidates, long sequenceNumberCutoff) {
        int count;
        long adjustedCutoff = Math.min(sequenceNumberCutoff, this.lastTruncatedSequenceNumber.get());
        ArrayList<SegmentMetadata> evictedSegments = new ArrayList<SegmentMetadata>(evictionCandidates.size());
        Object object = this.lock;
        synchronized (object) {
            evictionCandidates.stream().filter(m -> this.isEligibleForEviction((SegmentMetadata)m, adjustedCutoff)).forEach(m -> {
                StreamSegmentMetadata removedMetadata = this.metadataById.remove(m.getId());
                removedMetadata.markInactive();
                this.metadataByName.remove(m.getName());
                evictedSegments.add((SegmentMetadata)m);
            });
            count = this.metadataById.size();
        }
        if (evictedSegments.size() > 0) {
            log.info("{}: EvictedStreamSegments Count = {}, Active = {}", new Object[]{this.traceObjectId, evictedSegments.size(), count});
            this.metrics.segmentCount(count);
        }
        return evictedSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cleanupExtendedAttributes(int maximumAttributeCount, long sequenceNumberCutoff) {
        ArrayList<StreamSegmentMetadata> metadatas;
        Object object = this.lock;
        synchronized (object) {
            metadatas = new ArrayList<StreamSegmentMetadata>(this.metadataById.values());
        }
        long adjustedCutoff = Math.min(sequenceNumberCutoff, this.lastTruncatedSequenceNumber.get());
        int count = 0;
        for (StreamSegmentMetadata sm : metadatas) {
            count += sm.cleanupAttributes(maximumAttributeCount, adjustedCutoff);
        }
        if (count > 0) {
            log.info("{}: EvictedExtendedAttributes Count = {}", (Object)this.traceObjectId, (Object)count);
        }
        return count;
    }

    private boolean isEligibleForEviction(SegmentMetadata metadata, long sequenceNumberCutoff) {
        return !metadata.isPinned() && (metadata.getLastUsed() < sequenceNumberCutoff || metadata.isDeleted() && metadata.getLastUsed() <= this.lastTruncatedSequenceNumber.get());
    }

    @Override
    public void enterRecoveryMode() {
        this.ensureNonRecoveryMode();
        this.recoveryMode.set(true);
        log.info("{}: Enter RecoveryMode.", (Object)this.traceObjectId);
    }

    @Override
    public void exitRecoveryMode() {
        this.ensureRecoveryMode();
        this.recoveryMode.set(false);
        log.info("{}: Exit RecoveryMode.", (Object)this.traceObjectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.ensureRecoveryMode();
        this.sequenceNumber.set(0L);
        this.lastTruncatedSequenceNumber.set(0L);
        this.epoch.set(Long.MIN_VALUE);
        TreeMap<Long, LogAddress> treeMap = this.lock;
        synchronized (treeMap) {
            this.metadataByName.clear();
            this.metadataById.clear();
        }
        treeMap = this.truncationMarkers;
        synchronized (treeMap) {
            this.truncationMarkers.clear();
            this.truncationPoints.clear();
        }
        log.info("{}: Reset.", (Object)this.traceObjectId);
    }

    private void ensureRecoveryMode() {
        Preconditions.checkState((boolean)this.isRecoveryMode(), (Object)"StreamSegmentContainerMetadata is not in recovery mode. Cannot execute this operation.");
    }

    private void ensureNonRecoveryMode() {
        Preconditions.checkState((!this.isRecoveryMode() ? 1 : 0) != 0, (Object)"StreamSegmentContainerMetadata is in recovery mode. Cannot execute this operation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordTruncationMarker(long operationSequenceNumber, LogAddress address) {
        Exceptions.checkArgument((operationSequenceNumber >= 0L ? 1 : 0) != 0, (String)"operationSequenceNumber", (String)"Operation Sequence Number must be a positive number.", (Object[])new Object[0]);
        Preconditions.checkNotNull((Object)address, (Object)"address");
        TreeMap<Long, LogAddress> treeMap = this.truncationMarkers;
        synchronized (treeMap) {
            LogAddress existing = this.truncationMarkers.getOrDefault(operationSequenceNumber, null);
            if (existing == null || existing.getSequence() < address.getSequence()) {
                this.truncationMarkers.put(operationSequenceNumber, address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTruncationMarkers(long upToOperationSequenceNumber) {
        TreeMap<Long, LogAddress> treeMap = this.truncationMarkers;
        synchronized (treeMap) {
            this.truncationMarkers.headMap(upToOperationSequenceNumber, true).clear();
            this.truncationPoints.headSet(upToOperationSequenceNumber, true).clear();
        }
        this.lastTruncatedSequenceNumber.set(upToOperationSequenceNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogAddress getClosestTruncationMarker(long operationSequenceNumber) {
        Map.Entry<Long, LogAddress> result;
        TreeMap<Long, LogAddress> treeMap = this.truncationMarkers;
        synchronized (treeMap) {
            result = this.truncationMarkers.floorEntry(operationSequenceNumber);
        }
        return result == null ? null : result.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValidTruncationPoint(long sequenceNumber) {
        Exceptions.checkArgument((sequenceNumber >= 0L ? 1 : 0) != 0, (String)"sequenceNumber", (String)"Operation Sequence Number must be a positive number.", (Object[])new Object[0]);
        TreeMap<Long, LogAddress> treeMap = this.truncationMarkers;
        synchronized (treeMap) {
            this.truncationPoints.add(sequenceNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidTruncationPoint(long sequenceNumber) {
        TreeMap<Long, LogAddress> treeMap = this.truncationMarkers;
        synchronized (treeMap) {
            return this.truncationPoints.contains(sequenceNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getClosestValidTruncationPoint(long sequenceNumber) {
        Long result;
        TreeMap<Long, LogAddress> treeMap = this.truncationMarkers;
        synchronized (treeMap) {
            result = this.truncationPoints.floor(sequenceNumber);
        }
        return result == null ? Long.MIN_VALUE : result;
    }
}

