/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Runnables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.StreamSegmentExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.tables.BadKeyVersionException;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.contracts.tables.TableStore;
import io.pravega.segmentstore.server.containers.MetadataStore;
import io.pravega.shared.segment.StreamSegmentNameUtils;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TableMetadataStore
extends MetadataStore {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(TableMetadataStore.class);
    private final TableStore tableStore;
    private final String metadataSegmentName;
    private final AtomicBoolean initialized;

    TableMetadataStore(MetadataStore.Connector connector, @NonNull TableStore tableStore, Executor executor) {
        super(connector, executor);
        if (tableStore == null) {
            throw new NullPointerException("tableStore is marked @NonNull but is null");
        }
        this.tableStore = tableStore;
        this.metadataSegmentName = StreamSegmentNameUtils.getMetadataSegmentName((int)connector.getContainerMetadata().getContainerId());
        this.initialized = new AtomicBoolean(false);
    }

    @Override
    public CompletableFuture<Void> initialize(Duration timeout) {
        Preconditions.checkState((!this.initialized.get() ? 1 : 0) != 0, (Object)"TableMetadataStore is already initialized.");
        List<AttributeUpdate> attributes = TableAttributes.DEFAULT_VALUES.entrySet().stream().map(e -> new AttributeUpdate((UUID)e.getKey(), AttributeUpdateType.None, ((Long)e.getValue()).longValue())).collect(Collectors.toList());
        return this.submitAssignment(MetadataStore.SegmentInfo.newSegment(this.metadataSegmentName, attributes), true, timeout).thenAccept(segmentId -> {
            this.initialized.set(true);
            log.info("{}: Metadata Segment pinned. Name = '{}', Id = '{}'", new Object[]{this.traceObjectId, this.metadataSegmentName, segmentId});
        });
    }

    @Override
    CompletableFuture<Void> createSegment(String segmentName, Collection<AttributeUpdate> attributes, Duration timeout) {
        this.ensureInitialized();
        Preconditions.checkArgument((!this.metadataSegmentName.equals(segmentName) ? 1 : 0) != 0, (Object)"Cannot create Metadata Segment if already initialized.");
        return super.createSegment(segmentName, attributes, timeout);
    }

    @Override
    protected CompletableFuture<Void> createSegment(String segmentName, ArrayView segmentInfo, TimeoutTimer timer) {
        this.ensureInitialized();
        TableEntry entry = TableEntry.notExists((ArrayView)this.getTableKey(segmentName), (ArrayView)segmentInfo);
        return this.tableStore.put(this.metadataSegmentName, Collections.singletonList(entry), timer.getRemaining()).handle((ignored, ex) -> {
            if (ex != null) {
                if (Exceptions.unwrap((Throwable)ex) instanceof BadKeyVersionException) {
                    ex = new StreamSegmentExistsException(segmentName);
                }
                throw new CompletionException((Throwable)ex);
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Boolean> clearSegmentInfo(String segmentName, Duration timeout) {
        return this.applyToSegment(segmentName, (entry, t2) -> this.tableStore.remove(this.metadataSegmentName, Collections.singleton(TableKey.unversioned((ArrayView)entry.getKey().getKey())), t2).thenApply(v -> true), () -> CompletableFuture.completedFuture(false), timeout);
    }

    @Override
    protected CompletableFuture<ArrayView> getSegmentInfoInternal(String segmentName, Duration timeout) {
        return this.applyToSegment(segmentName, (entry, t2) -> CompletableFuture.completedFuture(entry.getValue()), () -> Futures.failedFuture((Throwable)new StreamSegmentNotExistsException(segmentName)), timeout);
    }

    private <T> CompletableFuture<T> applyToSegment(String segmentName, BiFunction<TableEntry, Duration, CompletableFuture<T>> ifExists, Supplier<CompletableFuture<T>> ifNotExists, Duration timeout) {
        this.ensureInitialized();
        ArrayView key = this.getTableKey(segmentName);
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return this.tableStore.get(this.metadataSegmentName, Collections.singletonList(key), timer.getRemaining()).thenComposeAsync(existingData -> {
            assert (existingData.size() == 1) : "Expecting only one result";
            if (existingData.get(0) == null) {
                return (CompletionStage)ifNotExists.get();
            }
            return (CompletionStage)ifExists.apply((TableEntry)existingData.get(0), timer.getRemaining());
        }, this.executor);
    }

    @Override
    protected CompletableFuture<Void> updateSegmentInfo(String segmentName, ArrayView segmentInfo, Duration timeout) {
        this.ensureInitialized();
        TableEntry entry = TableEntry.unversioned((ArrayView)this.getTableKey(segmentName), (ArrayView)segmentInfo);
        return this.tableStore.put(this.metadataSegmentName, Collections.singletonList(entry), timeout).thenRun(Runnables.doNothing());
    }

    private void ensureInitialized() {
        Preconditions.checkState((boolean)this.initialized.get(), (Object)"TableMetadataStore is not initialized.");
    }

    private ArrayView getTableKey(String segmentName) {
        return new ByteArraySegment(segmentName.getBytes(Charsets.UTF_8));
    }
}

