/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.function.Callbacks;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.SequencedItemList;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.CachePolicy;
import io.pravega.segmentstore.server.DataCorruptionException;
import io.pravega.segmentstore.server.ReadIndexFactory;
import io.pravega.segmentstore.server.UpdateableContainerMetadata;
import io.pravega.segmentstore.server.containers.ContainerConfig;
import io.pravega.segmentstore.server.containers.StreamSegmentContainerMetadata;
import io.pravega.segmentstore.server.logs.DataFrameRecord;
import io.pravega.segmentstore.server.logs.MemoryStateUpdater;
import io.pravega.segmentstore.server.logs.OperationMetadataUpdater;
import io.pravega.segmentstore.server.logs.RecoveryProcessor;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.reading.ContainerReadIndexFactory;
import io.pravega.segmentstore.server.reading.ReadIndexConfig;
import io.pravega.segmentstore.storage.Cache;
import io.pravega.segmentstore.storage.CacheFactory;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.ReadOnlyStorage;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.mocks.InMemoryStorageFactory;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class DebugRecoveryProcessor
extends RecoveryProcessor
implements AutoCloseable {
    private final OperationCallbacks callbacks;
    private final ReadIndexFactory readIndexFactory;
    private final CacheManager cacheManager;
    private final Storage storage;

    private DebugRecoveryProcessor(UpdateableContainerMetadata metadata, DurableDataLog durableDataLog, ReadIndexFactory readIndexFactory, Storage storage, CacheManager cacheManager, OperationCallbacks callbacks) {
        super(metadata, durableDataLog, new MemoryStateUpdater((SequencedItemList<Operation>)new SequencedItemList(), readIndexFactory.createReadIndex(metadata, (ReadOnlyStorage)storage), null));
        this.readIndexFactory = readIndexFactory;
        this.storage = storage;
        this.callbacks = callbacks;
        this.cacheManager = cacheManager;
    }

    @Override
    public void close() {
        this.readIndexFactory.close();
        this.cacheManager.close();
        this.storage.close();
    }

    public static DebugRecoveryProcessor create(int containerId, DurableDataLog durableDataLog, ContainerConfig config, ReadIndexConfig readIndexConfig, ScheduledExecutorService executor, OperationCallbacks callbacks) {
        Preconditions.checkNotNull((Object)durableDataLog, (Object)"durableDataLog");
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)readIndexConfig, (Object)"readIndexConfig");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        Preconditions.checkNotNull((Object)callbacks, (Object)callbacks);
        StreamSegmentContainerMetadata metadata = new StreamSegmentContainerMetadata(containerId, config.getMaxActiveSegmentCount());
        CacheManager cacheManager = new CacheManager(new CachePolicy(Long.MAX_VALUE, Duration.ofHours(10L), Duration.ofHours(1L)), executor);
        cacheManager.startAsync().awaitRunning();
        ContainerReadIndexFactory rf = new ContainerReadIndexFactory(readIndexConfig, new NoOpCacheFactory(), cacheManager, executor);
        Storage s = new InMemoryStorageFactory(executor).createStorageAdapter();
        return new DebugRecoveryProcessor(metadata, durableDataLog, rf, s, cacheManager, callbacks);
    }

    @Override
    protected void recoverOperation(DataFrameRecord<Operation> dataFrameRecord, OperationMetadataUpdater metadataUpdater) throws DataCorruptionException {
        if (this.callbacks.beginRecoverOperation != null) {
            Callbacks.invokeSafely((BiConsumer)this.callbacks.beginRecoverOperation, (Object)dataFrameRecord.getItem(), dataFrameRecord.getFrameEntries(), null);
        }
        try {
            super.recoverOperation(dataFrameRecord, metadataUpdater);
        }
        catch (Throwable ex) {
            if (this.callbacks.operationFailed != null) {
                Callbacks.invokeSafely((BiConsumer)this.callbacks.operationFailed, (Object)dataFrameRecord.getItem(), (Object)ex, null);
            }
            throw ex;
        }
        if (this.callbacks.operationSuccess != null) {
            Callbacks.invokeSafely((Consumer)this.callbacks.operationSuccess, (Object)dataFrameRecord.getItem(), null);
        }
    }

    private static class NoOpCache
    implements Cache {
        private NoOpCache() {
        }

        public String getId() {
            return null;
        }

        public void insert(Cache.Key key, byte[] data) {
        }

        public void insert(Cache.Key key, BufferView data) {
        }

        public byte[] get(Cache.Key key) {
            throw new UnsupportedOperationException();
        }

        public void remove(Cache.Key key) {
        }

        public void close() {
        }
    }

    private static class NoOpCacheFactory
    implements CacheFactory {
        private NoOpCacheFactory() {
        }

        public Cache getCache(String id) {
            return new NoOpCache();
        }

        public void close() {
        }
    }

    public static class OperationCallbacks {
        private final BiConsumer<Operation, List<DataFrameRecord.EntryInfo>> beginRecoverOperation;
        private final Consumer<Operation> operationSuccess;
        private final BiConsumer<Operation, Throwable> operationFailed;

        @ConstructorProperties(value={"beginRecoverOperation", "operationSuccess", "operationFailed"})
        @SuppressFBWarnings(justification="generated code")
        public OperationCallbacks(BiConsumer<Operation, List<DataFrameRecord.EntryInfo>> beginRecoverOperation, Consumer<Operation> operationSuccess, BiConsumer<Operation, Throwable> operationFailed) {
            this.beginRecoverOperation = beginRecoverOperation;
            this.operationSuccess = operationSuccess;
            this.operationFailed = operationFailed;
        }
    }
}

