/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.util.SequencedItemList;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.server.CacheUtilizationProvider;
import io.pravega.segmentstore.server.ContainerMetadata;
import io.pravega.segmentstore.server.DataCorruptionException;
import io.pravega.segmentstore.server.ReadIndex;
import io.pravega.segmentstore.server.SegmentOperation;
import io.pravega.segmentstore.server.logs.operations.CachedStreamSegmentAppendOperation;
import io.pravega.segmentstore.server.logs.operations.MergeSegmentOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentAppendOperation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class MemoryStateUpdater
implements CacheUtilizationProvider {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(MemoryStateUpdater.class);
    private final ReadIndex readIndex;
    private final SequencedItemList<Operation> inMemoryOperationLog;
    private final Runnable commitSuccess;
    private final AtomicBoolean recoveryMode;

    MemoryStateUpdater(SequencedItemList<Operation> inMemoryOperationLog, ReadIndex readIndex, Runnable commitSuccess) {
        this.inMemoryOperationLog = (SequencedItemList)Preconditions.checkNotNull(inMemoryOperationLog, (Object)"inMemoryOperationLog");
        this.readIndex = (ReadIndex)Preconditions.checkNotNull((Object)readIndex, (Object)"readIndex");
        this.commitSuccess = commitSuccess;
        this.recoveryMode = new AtomicBoolean();
    }

    @Override
    public double getCacheUtilization() {
        return this.readIndex.getCacheUtilization();
    }

    @Override
    public double getCacheTargetUtilization() {
        return this.readIndex.getCacheTargetUtilization();
    }

    @Override
    public double getCacheMaxUtilization() {
        return this.readIndex.getCacheMaxUtilization();
    }

    @Override
    public void registerCleanupListener(CacheUtilizationProvider.CleanupListener listener) {
        this.readIndex.registerCleanupListener(listener);
    }

    void enterRecoveryMode(ContainerMetadata recoveryMetadataSource) {
        this.readIndex.enterRecoveryMode(recoveryMetadataSource);
        this.recoveryMode.set(true);
    }

    void exitRecoveryMode(boolean successfulRecovery) throws DataCorruptionException {
        this.readIndex.exitRecoveryMode(successfulRecovery);
        this.recoveryMode.set(false);
    }

    void process(Iterator<Operation> operations) throws DataCorruptionException {
        HashSet<Long> segmentIds = new HashSet<Long>();
        while (operations.hasNext()) {
            Operation op = operations.next();
            this.process(op);
            if (!(op instanceof SegmentOperation)) continue;
            segmentIds.add(((SegmentOperation)((Object)op)).getStreamSegmentId());
        }
        if (!this.recoveryMode.get()) {
            this.readIndex.triggerFutureReads(segmentIds);
            if (this.commitSuccess != null) {
                this.commitSuccess.run();
            }
        }
    }

    void process(Operation operation) throws DataCorruptionException {
        boolean added;
        if (operation instanceof StorageOperation) {
            this.addToReadIndex((StorageOperation)operation);
            if (operation instanceof StreamSegmentAppendOperation) {
                StreamSegmentAppendOperation appendOp = (StreamSegmentAppendOperation)operation;
                try {
                    operation = new CachedStreamSegmentAppendOperation(appendOp);
                }
                catch (Throwable ex) {
                    if (Exceptions.mustRethrow((Throwable)ex)) {
                        throw ex;
                    }
                    throw new DataCorruptionException(String.format("Unable to create a CachedStreamSegmentAppendOperation from operation '%s'.", operation), ex, new Object[0]);
                }
                try {
                    appendOp.close();
                }
                catch (Throwable ex) {
                    if (Exceptions.mustRethrow((Throwable)ex)) {
                        throw ex;
                    }
                    log.warn("Unable to release memory for operation '{}': ", (Object)operation, (Object)ex);
                }
            }
        }
        if (!(added = this.inMemoryOperationLog.add((SequencedItemList.Element)operation))) {
            throw new DataCorruptionException("About to have added a Log Operation to InMemoryOperationLog that was out of order.", new Object[0]);
        }
    }

    private void addToReadIndex(StorageOperation operation) {
        try {
            if (operation instanceof StreamSegmentAppendOperation) {
                StreamSegmentAppendOperation appendOperation = (StreamSegmentAppendOperation)operation;
                this.readIndex.append(appendOperation.getStreamSegmentId(), appendOperation.getStreamSegmentOffset(), appendOperation.getData());
            } else if (operation instanceof MergeSegmentOperation) {
                MergeSegmentOperation mergeOperation = (MergeSegmentOperation)operation;
                this.readIndex.beginMerge(mergeOperation.getStreamSegmentId(), mergeOperation.getStreamSegmentOffset(), mergeOperation.getSourceSegmentId());
            } else assert (!(operation instanceof CachedStreamSegmentAppendOperation)) : "attempted to add a CachedStreamSegmentAppendOperation to the ReadIndex";
        }
        catch (ObjectClosedException | StreamSegmentNotExistsException ex) {
            log.warn("Not adding operation '{}' to ReadIndex because it refers to a deleted StreamSegment.", (Object)operation);
        }
    }
}

