/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.server.logs.operations.MetadataOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import java.io.IOException;

public abstract class CheckpointOperationBase
extends MetadataOperation {
    private ByteArraySegment contents;

    public void setContents(ByteArraySegment contents) {
        Preconditions.checkNotNull((Object)contents, (Object)"contents");
        Preconditions.checkState((this.contents == null ? 1 : 0) != 0, (Object)"This operation has already had its contents set.");
        this.contents = contents;
    }

    public void clearContents() {
        this.contents = null;
    }

    public ByteArraySegment getContents() {
        return this.contents;
    }

    @Override
    public String toString() {
        return String.format("%s, Length = %d", super.toString(), this.contents == null ? 0 : this.contents.getLength());
    }

    static abstract class SerializerBase<T extends CheckpointOperationBase>
    extends Operation.OperationSerializer<T> {
        SerializerBase() {
        }

        protected abstract Operation.OperationBuilder<T> newBuilder();

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        @Override
        protected void beforeSerialization(T o) {
            super.beforeSerialization(o);
            Preconditions.checkState((((CheckpointOperationBase)o).getContents() != null ? 1 : 0) != 0, (Object)"Contents has not been assigned.");
        }

        private void write00(T o, RevisionDataOutput target) throws IOException {
            ByteArraySegment c = ((CheckpointOperationBase)o).getContents();
            target.length(8 + target.getCompactIntLength(c.getLength()) + c.getLength());
            target.writeLong(((Operation)o).getSequenceNumber());
            target.writeArray(c.array(), c.arrayOffset(), c.getLength());
        }

        private void read00(RevisionDataInput source, Operation.OperationBuilder<T> b) throws IOException {
            ((CheckpointOperationBase)b.instance).setSequenceNumber(source.readLong());
            ((CheckpointOperationBase)b.instance).setContents(new ByteArraySegment(source.readArray()));
        }
    }
}

