/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.Timer;
import io.pravega.common.function.Callbacks;
import io.pravega.segmentstore.server.logs.operations.Operation;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableOperation {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(CompletableOperation.class);
    private final Operation operation;
    private final Consumer<Throwable> failureHandler;
    private final Consumer<Void> successHandler;
    private final Timer timer;
    private boolean done;

    public CompletableOperation(Operation operation, CompletableFuture<Void> callbackFuture) {
        this(operation, callbackFuture::complete, callbackFuture::completeExceptionally);
        Exceptions.checkArgument((!callbackFuture.isDone() ? 1 : 0) != 0, (String)"callbackFuture", (String)"CallbackFuture is already done.", (Object[])new Object[0]);
    }

    CompletableOperation(Operation operation, Consumer<Void> successHandler, Consumer<Throwable> failureHandler) {
        Preconditions.checkNotNull((Object)operation, (Object)"operation");
        this.operation = operation;
        this.failureHandler = failureHandler;
        this.successHandler = successHandler;
        this.timer = new Timer();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void complete() {
        long seqNo = this.operation.getSequenceNumber();
        Preconditions.checkState((seqNo >= 0L ? 1 : 0) != 0, (Object)"About to complete a CompletableOperation that has no sequence number.");
        this.done = true;
        if (this.successHandler != null) {
            Callbacks.invokeSafely(this.successHandler, null, cex -> log.error("Success Callback invocation failure.", cex));
        }
    }

    public void fail(Throwable ex) {
        this.done = true;
        if (this.failureHandler != null) {
            Callbacks.invokeSafely(this.failureHandler, (Object)ex, cex -> log.error("Fail Callback invocation failure.", cex));
        }
    }

    public boolean isDone() {
        return this.done;
    }

    @SuppressFBWarnings(justification="generated code")
    public Timer getTimer() {
        return this.timer;
    }
}

