/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.server.logs.operations.AttributeUpdaterOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageOperation;
import java.io.IOException;
import java.util.Collection;

public class StreamSegmentAppendOperation
extends StorageOperation
implements AttributeUpdaterOperation,
AutoCloseable {
    private static final long NO_OFFSET = -1L;
    private long streamSegmentOffset;
    private BufferView data;
    private Collection<AttributeUpdate> attributeUpdates;

    public StreamSegmentAppendOperation(long streamSegmentId, BufferView data, Collection<AttributeUpdate> attributeUpdates) {
        this(streamSegmentId, -1L, data, attributeUpdates);
    }

    public StreamSegmentAppendOperation(long streamSegmentId, long offset, BufferView data, Collection<AttributeUpdate> attributeUpdates) {
        super(streamSegmentId);
        this.data = (BufferView)Preconditions.checkNotNull((Object)data, (Object)"data");
        this.data.retain();
        this.streamSegmentOffset = offset;
        this.attributeUpdates = attributeUpdates;
    }

    private StreamSegmentAppendOperation() {
    }

    @Override
    public void close() {
        this.data.release();
    }

    public void setStreamSegmentOffset(long value) {
        this.streamSegmentOffset = value;
    }

    public BufferView getData() {
        return this.data;
    }

    @Override
    public Collection<AttributeUpdate> getAttributeUpdates() {
        return this.attributeUpdates;
    }

    @Override
    public long getStreamSegmentOffset() {
        return this.streamSegmentOffset;
    }

    @Override
    public long getLength() {
        return this.data.getLength();
    }

    @Override
    public String toString() {
        return String.format("%s, Offset = %s, Length = %d, Attributes = %d", super.toString(), this.toString(this.streamSegmentOffset, -1), this.data.getLength(), this.attributeUpdates == null ? 0 : this.attributeUpdates.size());
    }

    static class Serializer
    extends Operation.OperationSerializer<StreamSegmentAppendOperation> {
        private static final int STATIC_LENGTH = 24;
        private static final int ATTRIBUTE_UPDATE_LENGTH = 33;

        Serializer() {
        }

        protected Operation.OperationBuilder<StreamSegmentAppendOperation> newBuilder() {
            return new Operation.OperationBuilder<StreamSegmentAppendOperation>(new StreamSegmentAppendOperation());
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        @Override
        protected void beforeSerialization(StreamSegmentAppendOperation o) {
            super.beforeSerialization(o);
            Preconditions.checkState((o.streamSegmentOffset >= 0L ? 1 : 0) != 0, (Object)"StreamSegment Offset has not been assigned.");
        }

        private void write00(StreamSegmentAppendOperation o, RevisionDataOutput target) throws IOException {
            int attributesLength = o.attributeUpdates == null ? target.getCompactIntLength(0) : target.getCollectionLength(o.attributeUpdates.size(), 33);
            int dataLength = o.getData().getLength();
            target.length(24 + target.getCompactIntLength(dataLength) + dataLength + attributesLength);
            target.writeLong(o.getSequenceNumber());
            target.writeLong(o.getStreamSegmentId());
            target.writeLong(o.streamSegmentOffset);
            target.writeBuffer(o.data);
            target.writeCollection(o.attributeUpdates, this::writeAttributeUpdate00);
        }

        private void read00(RevisionDataInput source, Operation.OperationBuilder<StreamSegmentAppendOperation> b) throws IOException {
            ((StreamSegmentAppendOperation)b.instance).setSequenceNumber(source.readLong());
            ((StreamSegmentAppendOperation)b.instance).setStreamSegmentId(source.readLong());
            ((StreamSegmentAppendOperation)b.instance).streamSegmentOffset = source.readLong();
            ((StreamSegmentAppendOperation)b.instance).data = (BufferView)new ByteArraySegment(source.readArray());
            ((StreamSegmentAppendOperation)b.instance).attributeUpdates = source.readCollection(this::readAttributeUpdate00);
        }

        private void writeAttributeUpdate00(RevisionDataOutput target, AttributeUpdate au) throws IOException {
            target.writeUUID(au.getAttributeId());
            target.writeByte((int)au.getUpdateType().getTypeId());
            target.writeLong(au.getValue());
            target.writeLong(au.getComparisonValue());
        }

        private AttributeUpdate readAttributeUpdate00(RevisionDataInput source) throws IOException {
            return new AttributeUpdate(source.readUUID(), AttributeUpdateType.get((byte)source.readByte()), source.readLong(), source.readLong());
        }
    }
}

