/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.server.logs.operations.MetadataOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public class StreamSegmentMapOperation
extends MetadataOperation {
    private long streamSegmentId;
    private String streamSegmentName;
    private long startOffset;
    private long length;
    private boolean sealed;
    private Map<UUID, Long> attributes;
    private boolean pinned;

    public StreamSegmentMapOperation(SegmentProperties streamSegmentProperties) {
        this.streamSegmentId = Long.MIN_VALUE;
        this.streamSegmentName = streamSegmentProperties.getName();
        this.startOffset = streamSegmentProperties.getStartOffset();
        this.length = streamSegmentProperties.getLength();
        this.sealed = streamSegmentProperties.isSealed();
        this.attributes = streamSegmentProperties.getAttributes();
        this.pinned = false;
    }

    private StreamSegmentMapOperation() {
    }

    public String getStreamSegmentName() {
        return this.streamSegmentName;
    }

    public long getStreamSegmentId() {
        return this.streamSegmentId;
    }

    public void setStreamSegmentId(long value) {
        Preconditions.checkState((this.streamSegmentId == Long.MIN_VALUE ? 1 : 0) != 0, (Object)"StreamSegmentId has already been assigned for this operation.");
        Preconditions.checkArgument((value != Long.MIN_VALUE ? 1 : 0) != 0, (Object)"Invalid StreamSegmentId");
        this.streamSegmentId = value;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void markPinned() {
        this.pinned = true;
    }

    public Map<UUID, Long> getAttributes() {
        return this.attributes;
    }

    @Override
    public String toString() {
        return String.format("%s, Id = %s, Name = %s, Start = %d, Length = %d, Sealed = %s, Pinned = %s", super.toString(), this.toString(this.getStreamSegmentId(), Long.MIN_VALUE), this.getStreamSegmentName(), this.getStartOffset(), this.getLength(), this.isSealed(), this.isPinned());
    }

    static class Serializer
    extends Operation.OperationSerializer<StreamSegmentMapOperation> {
        private static final int STATIC_LENGTH = 34;

        Serializer() {
        }

        protected Operation.OperationBuilder<StreamSegmentMapOperation> newBuilder() {
            return new Operation.OperationBuilder<StreamSegmentMapOperation>(new StreamSegmentMapOperation());
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        @Override
        protected void beforeSerialization(StreamSegmentMapOperation o) {
            super.beforeSerialization(o);
            Preconditions.checkState((o.streamSegmentId != Long.MIN_VALUE ? 1 : 0) != 0, (Object)"StreamSegment Id has not been assigned.");
        }

        private void write00(StreamSegmentMapOperation o, RevisionDataOutput target) throws IOException {
            target.length(34 + target.getUTFLength(o.streamSegmentName) + target.getMapLength(o.attributes.size(), 16, 8));
            target.writeLong(o.getSequenceNumber());
            target.writeLong(o.streamSegmentId);
            target.writeUTF(o.streamSegmentName);
            target.writeLong(o.startOffset);
            target.writeLong(o.length);
            target.writeBoolean(o.sealed);
            target.writeMap(o.attributes, RevisionDataOutput::writeUUID, DataOutput::writeLong);
            target.writeBoolean(o.pinned);
        }

        private void read00(RevisionDataInput source, Operation.OperationBuilder<StreamSegmentMapOperation> b) throws IOException {
            ((StreamSegmentMapOperation)b.instance).setSequenceNumber(source.readLong());
            ((StreamSegmentMapOperation)b.instance).streamSegmentId = source.readLong();
            ((StreamSegmentMapOperation)b.instance).streamSegmentName = source.readUTF();
            ((StreamSegmentMapOperation)b.instance).startOffset = source.readLong();
            ((StreamSegmentMapOperation)b.instance).length = source.readLong();
            ((StreamSegmentMapOperation)b.instance).sealed = source.readBoolean();
            ((StreamSegmentMapOperation)b.instance).attributes = source.readMap(RevisionDataInput::readUUID, DataInput::readLong);
            ((StreamSegmentMapOperation)b.instance).pinned = source.readBoolean();
        }
    }
}

