/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageOperation;
import java.io.IOException;

public class StreamSegmentSealOperation
extends StorageOperation {
    private long streamSegmentOffset;

    public StreamSegmentSealOperation(long streamSegmentId) {
        super(streamSegmentId);
        this.streamSegmentOffset = -1L;
    }

    private StreamSegmentSealOperation() {
    }

    public void setStreamSegmentOffset(long value) {
        Exceptions.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"value", (String)"StreamSegment Offset must be a non-negative number.", (Object[])new Object[0]);
        this.streamSegmentOffset = value;
    }

    @Override
    public long getStreamSegmentOffset() {
        return this.streamSegmentOffset;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public String toString() {
        return String.format("%s, Length = %s", super.toString(), this.toString(this.streamSegmentOffset, -1));
    }

    static class Serializer
    extends Operation.OperationSerializer<StreamSegmentSealOperation> {
        private static final int SERIALIZATION_LENGTH = 24;

        Serializer() {
        }

        protected Operation.OperationBuilder<StreamSegmentSealOperation> newBuilder() {
            return new Operation.OperationBuilder<StreamSegmentSealOperation>(new StreamSegmentSealOperation());
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        @Override
        protected void beforeSerialization(StreamSegmentSealOperation o) {
            super.beforeSerialization(o);
            Preconditions.checkState((o.streamSegmentOffset >= 0L ? 1 : 0) != 0, (Object)"StreamSegment Offset has not been assigned.");
        }

        private void write00(StreamSegmentSealOperation o, RevisionDataOutput target) throws IOException {
            target.length(24);
            target.writeLong(o.getSequenceNumber());
            target.writeLong(o.getStreamSegmentId());
            target.writeLong(o.streamSegmentOffset);
        }

        private void read00(RevisionDataInput source, Operation.OperationBuilder<StreamSegmentSealOperation> b) throws IOException {
            ((StreamSegmentSealOperation)b.instance).setSequenceNumber(source.readLong());
            ((StreamSegmentSealOperation)b.instance).setStreamSegmentId(source.readLong());
            ((StreamSegmentSealOperation)b.instance).streamSegmentOffset = source.readLong();
        }
    }
}

