/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.segmentstore.server.SegmentOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageOperation;
import java.io.IOException;

public class StreamSegmentTruncateOperation
extends StorageOperation
implements SegmentOperation {
    private long streamSegmentId;
    private long streamSegmentOffset;

    public StreamSegmentTruncateOperation(long streamSegmentId, long offset) {
        super(streamSegmentId);
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be a non-negative number.");
        this.streamSegmentId = streamSegmentId;
        this.streamSegmentOffset = offset;
    }

    private StreamSegmentTruncateOperation() {
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public String toString() {
        return String.format("%s, Offset = %s", super.toString(), this.streamSegmentOffset);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public long getStreamSegmentId() {
        return this.streamSegmentId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public long getStreamSegmentOffset() {
        return this.streamSegmentOffset;
    }

    static class Serializer
    extends Operation.OperationSerializer<StreamSegmentTruncateOperation> {
        private static final int SERIALIZATION_LENGTH = 24;

        Serializer() {
        }

        protected Operation.OperationBuilder<StreamSegmentTruncateOperation> newBuilder() {
            return new Operation.OperationBuilder<StreamSegmentTruncateOperation>(new StreamSegmentTruncateOperation());
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(StreamSegmentTruncateOperation o, RevisionDataOutput target) throws IOException {
            target.length(24);
            target.writeLong(o.getSequenceNumber());
            target.writeLong(o.streamSegmentId);
            target.writeLong(o.streamSegmentOffset);
        }

        private void read00(RevisionDataInput source, Operation.OperationBuilder<StreamSegmentTruncateOperation> b) throws IOException {
            ((StreamSegmentTruncateOperation)b.instance).setSequenceNumber(source.readLong());
            ((StreamSegmentTruncateOperation)b.instance).streamSegmentId = source.readLong();
            ((StreamSegmentTruncateOperation)b.instance).streamSegmentOffset = source.readLong();
        }
    }
}

