/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.mocks;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.concurrent.Futures;
import io.pravega.segmentstore.server.ContainerHandle;
import io.pravega.segmentstore.server.SegmentContainerManager;
import io.pravega.segmentstore.server.SegmentContainerRegistry;
import io.pravega.shared.segment.SegmentToContainerMapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LocalSegmentContainerManager
implements SegmentContainerManager {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(LocalSegmentContainerManager.class);
    private static final Duration INIT_TIMEOUT_PER_CONTAINER = Duration.ofSeconds(30L);
    private static final Duration CLOSE_TIMEOUT_PER_CONTAINER = Duration.ofSeconds(30L);
    private final SegmentContainerRegistry registry;
    private final SegmentToContainerMapper segmentToContainerMapper;
    @GuardedBy(value="handles")
    private final HashMap<Integer, ContainerHandle> handles;
    private final AtomicBoolean closed;

    public LocalSegmentContainerManager(SegmentContainerRegistry containerRegistry, SegmentToContainerMapper segmentToContainerMapper) {
        Preconditions.checkNotNull((Object)containerRegistry, (Object)"containerRegistry");
        Preconditions.checkNotNull((Object)segmentToContainerMapper, (Object)"segmentToContainerMapper");
        Exceptions.checkArgument((containerRegistry.getContainerCount() == 0 ? 1 : 0) != 0, (String)"containerRegistry", (String)"containerRegistry already has containers registered.", (Object[])new Object[0]);
        this.registry = containerRegistry;
        this.segmentToContainerMapper = segmentToContainerMapper;
        this.handles = new HashMap();
        this.closed = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            ArrayList<CompletableFuture<Void>> results = new ArrayList<CompletableFuture<Void>>();
            HashMap<Integer, ContainerHandle> hashMap = this.handles;
            synchronized (hashMap) {
                ArrayList<ContainerHandle> toClose = new ArrayList<ContainerHandle>(this.handles.values());
                for (ContainerHandle handle : toClose) {
                    results.add(this.registry.stopContainer(handle, CLOSE_TIMEOUT_PER_CONTAINER));
                }
            }
            Futures.await((CompletableFuture)Futures.allOf(results), (long)CLOSE_TIMEOUT_PER_CONTAINER.toMillis());
        }
    }

    @Override
    public void initialize() {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"initialize", (Object[])new Object[0]);
        long containerCount = this.segmentToContainerMapper.getTotalContainerCount();
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        int containerId = 0;
        while ((long)containerId < containerCount) {
            futures.add(this.registry.startContainer(containerId, INIT_TIMEOUT_PER_CONTAINER).thenAccept(this::registerHandle));
            ++containerId;
        }
        Futures.allOf(futures).join();
        LoggerHelpers.traceLeave((Logger)log, (String)"initialize", (long)traceId, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterHandle(ContainerHandle handle) {
        HashMap<Integer, ContainerHandle> hashMap = this.handles;
        synchronized (hashMap) {
            assert (this.handles.containsKey(handle.getContainerId())) : "found unregistered handle " + handle.getContainerId();
            this.handles.remove(handle.getContainerId());
        }
        log.info("Container {} has been unregistered.", (Object)handle.getContainerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerHandle(ContainerHandle handle) {
        assert (handle != null) : "handle is null.";
        HashMap<Integer, ContainerHandle> hashMap = this.handles;
        synchronized (hashMap) {
            assert (!this.handles.containsKey(handle.getContainerId())) : "handle is already registered " + handle.getContainerId();
            this.handles.put(handle.getContainerId(), handle);
            handle.setContainerStoppedListener(id -> this.unregisterHandle(handle));
        }
        log.info("Container {} has been registered.", (Object)handle.getContainerId());
    }
}

