/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import io.pravega.common.Exceptions;
import io.pravega.segmentstore.contracts.ReadResultEntryContents;
import io.pravega.segmentstore.contracts.ReadResultEntryType;
import io.pravega.segmentstore.server.reading.ReadResultEntryBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

class CacheReadResultEntry
extends ReadResultEntryBase {
    CacheReadResultEntry(long streamSegmentOffset, byte[] data, int dataOffset, int dataLength) {
        super(ReadResultEntryType.Cache, streamSegmentOffset + (long)dataOffset, dataLength);
        Exceptions.checkArrayRange((long)dataOffset, (int)dataLength, (long)data.length, (String)"dataOffset", (String)"dataLength");
        this.complete(new ReadResultEntryContents((InputStream)new ByteArrayInputStream(data, dataOffset, dataLength), dataLength));
    }

    CacheReadResultEntry(long streamSegmentOffset, InputStream data, int dataLength) {
        super(ReadResultEntryType.Cache, streamSegmentOffset, dataLength);
        this.complete(new ReadResultEntryContents(data, dataLength));
    }
}

