/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import io.pravega.common.Exceptions;
import io.pravega.segmentstore.server.reading.FutureReadResultEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class FutureReadResultEntryCollection {
    @GuardedBy(value="reads")
    private final PriorityQueue<FutureReadResultEntry> reads = new PriorityQueue(FutureReadResultEntryCollection::entryComparator);
    @GuardedBy(value="reads")
    private boolean closed;

    FutureReadResultEntryCollection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FutureReadResultEntry> close() {
        List<FutureReadResultEntry> result;
        PriorityQueue<FutureReadResultEntry> priorityQueue = this.reads;
        synchronized (priorityQueue) {
            if (this.closed) {
                result = Collections.emptyList();
            } else {
                result = new ArrayList<FutureReadResultEntry>(this.reads);
                this.reads.clear();
                this.closed = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(FutureReadResultEntry entry) {
        PriorityQueue<FutureReadResultEntry> priorityQueue = this.reads;
        synchronized (priorityQueue) {
            Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
            this.reads.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<FutureReadResultEntry> poll(long maxOffset) {
        ArrayList<FutureReadResultEntry> result = new ArrayList<FutureReadResultEntry>();
        PriorityQueue<FutureReadResultEntry> priorityQueue = this.reads;
        synchronized (priorityQueue) {
            Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
            while (this.reads.size() > 0 && this.reads.peek().getStreamSegmentOffset() <= maxOffset) {
                result.add(this.reads.poll());
            }
        }
        return result;
    }

    Collection<FutureReadResultEntry> pollAll() {
        return this.poll(Long.MAX_VALUE);
    }

    static int entryComparator(FutureReadResultEntry e1, FutureReadResultEntry e2) {
        if (e1.getStreamSegmentOffset() < e2.getStreamSegmentOffset()) {
            return -1;
        }
        if (e1.getStreamSegmentOffset() > e2.getStreamSegmentOffset()) {
            return 1;
        }
        return 0;
    }
}

