/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import java.time.Duration;

public class ReadIndexConfig {
    public static final Property<Integer> STORAGE_READ_ALIGNMENT = Property.named((String)"storageReadAlignment", (Object)0x100000);
    public static final Property<Integer> MEMORY_READ_MIN_LENGTH = Property.named((String)"memoryReadMinLength", (Object)4096);
    public static final Property<Integer> STORAGE_READ_DEFAULT_TIMEOUT = Property.named((String)"storageReadDefaultTimeoutMillis", (Object)30000);
    private static final String COMPONENT_CODE = "readindex";
    private final int storageReadAlignment;
    private final int memoryReadMinLength;
    private final Duration storageReadDefaultTimeout;

    private ReadIndexConfig(TypedProperties properties) throws ConfigurationException {
        this.storageReadAlignment = properties.getInt(STORAGE_READ_ALIGNMENT);
        this.memoryReadMinLength = properties.getInt(MEMORY_READ_MIN_LENGTH);
        this.storageReadDefaultTimeout = Duration.ofMillis(properties.getInt(STORAGE_READ_DEFAULT_TIMEOUT));
    }

    public static ConfigBuilder<ReadIndexConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, ReadIndexConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    public int getStorageReadAlignment() {
        return this.storageReadAlignment;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getMemoryReadMinLength() {
        return this.memoryReadMinLength;
    }

    @SuppressFBWarnings(justification="generated code")
    public Duration getStorageReadDefaultTimeout() {
        return this.storageReadDefaultTimeout;
    }
}

