/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.base.Preconditions;
import io.pravega.common.util.SortedIndex;
import javax.annotation.concurrent.GuardedBy;

abstract class ReadIndexEntry
implements SortedIndex.IndexEntry {
    private final long streamSegmentOffset;
    @GuardedBy(value="this")
    private int generation;

    ReadIndexEntry(long streamSegmentOffset) {
        Preconditions.checkArgument((streamSegmentOffset >= 0L ? 1 : 0) != 0, (Object)"streamSegmentOffset must be a non-negative number.");
        this.streamSegmentOffset = streamSegmentOffset;
    }

    synchronized int getGeneration() {
        return this.generation;
    }

    synchronized void setGeneration(int generation) {
        this.generation = generation;
    }

    long getStreamSegmentOffset() {
        return this.streamSegmentOffset;
    }

    abstract long getLength();

    long getLastStreamSegmentOffset() {
        return this.streamSegmentOffset + this.getLength() - 1L;
    }

    abstract boolean isDataEntry();

    public synchronized String toString() {
        return String.format("Offset = %d, Length = %d, Gen = %d", this.streamSegmentOffset, this.getLength(), this.generation);
    }

    public long key() {
        return this.streamSegmentOffset;
    }
}

