/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.contracts.ReadResultEntryContents;
import io.pravega.segmentstore.contracts.ReadResultEntryType;
import io.pravega.segmentstore.server.reading.ReadResultEntryBase;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

class StorageReadResultEntry
extends ReadResultEntryBase {
    private final ContentFetcher contentFetcher;
    private final AtomicBoolean contentRequested;

    StorageReadResultEntry(long streamSegmentOffset, int requestedReadLength, ContentFetcher contentFetcher) {
        super(ReadResultEntryType.Storage, streamSegmentOffset, requestedReadLength);
        Preconditions.checkNotNull((Object)contentFetcher, (Object)"contentFetcher");
        this.contentFetcher = contentFetcher;
        this.contentRequested = new AtomicBoolean(false);
    }

    @Override
    public void requestContent(Duration timeout) {
        Preconditions.checkState((!this.contentRequested.getAndSet(true) ? 1 : 0) != 0, (Object)"Content has already been successful requested. Cannot re-request.");
        try {
            this.contentFetcher.accept(this.getStreamSegmentOffset(), this.getRequestedReadLength(), this::complete, this::fail, timeout);
        }
        catch (Throwable ex) {
            this.contentRequested.set(false);
            throw ex;
        }
    }

    @FunctionalInterface
    static interface ContentFetcher {
        public void accept(long var1, int var3, Consumer<ReadResultEntryContents> var4, Consumer<Throwable> var5, Duration var6);
    }
}

