/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.AvlTreeIndex;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.common.util.SortedIndex;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.ReadResultEntryContents;
import io.pravega.segmentstore.contracts.ReadResultEntryType;
import io.pravega.segmentstore.contracts.StreamSegmentSealedException;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.reading.CacheIndexEntry;
import io.pravega.segmentstore.server.reading.CacheKey;
import io.pravega.segmentstore.server.reading.CacheReadResultEntry;
import io.pravega.segmentstore.server.reading.CompletableReadResultEntry;
import io.pravega.segmentstore.server.reading.EndOfStreamSegmentReadResultEntry;
import io.pravega.segmentstore.server.reading.FutureReadResultEntry;
import io.pravega.segmentstore.server.reading.FutureReadResultEntryCollection;
import io.pravega.segmentstore.server.reading.MergedIndexEntry;
import io.pravega.segmentstore.server.reading.PendingMerge;
import io.pravega.segmentstore.server.reading.ReadIndexConfig;
import io.pravega.segmentstore.server.reading.ReadIndexEntry;
import io.pravega.segmentstore.server.reading.ReadIndexSummary;
import io.pravega.segmentstore.server.reading.ReadResultEntryBase;
import io.pravega.segmentstore.server.reading.RedirectIndexEntry;
import io.pravega.segmentstore.server.reading.RedirectedReadResultEntry;
import io.pravega.segmentstore.server.reading.StorageReadManager;
import io.pravega.segmentstore.server.reading.StorageReadResultEntry;
import io.pravega.segmentstore.server.reading.StreamSegmentReadResult;
import io.pravega.segmentstore.server.reading.TruncatedReadResultEntry;
import io.pravega.segmentstore.storage.Cache;
import io.pravega.segmentstore.storage.ReadOnlyStorage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class StreamSegmentReadIndex
implements CacheManager.Client,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamSegmentReadIndex.class);
    private final String traceObjectId;
    @GuardedBy(value="lock")
    private final SortedIndex<ReadIndexEntry> indexEntries;
    private final ReadIndexConfig config;
    @GuardedBy(value="lock")
    private final Cache cache;
    private final FutureReadResultEntryCollection futureReads;
    @GuardedBy(value="lock")
    private final HashMap<Long, PendingMerge> pendingMergers;
    private final StorageReadManager storageReadManager;
    private final ReadIndexSummary summary;
    private final ScheduledExecutorService executor;
    private SegmentMetadata metadata;
    @GuardedBy(value="lock")
    private long lastAppendedOffset;
    private boolean recoveryMode;
    private boolean closed;
    private boolean merged;
    private final Object lock = new Object();

    StreamSegmentReadIndex(ReadIndexConfig config, SegmentMetadata metadata, Cache cache, ReadOnlyStorage storage, ScheduledExecutorService executor, boolean recoveryMode) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        Preconditions.checkNotNull((Object)cache, (Object)"cache");
        Preconditions.checkNotNull((Object)storage, (Object)"storage");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.traceObjectId = String.format("ReadIndex[%d-%d]", metadata.getContainerId(), metadata.getId());
        this.config = config;
        this.metadata = metadata;
        this.cache = cache;
        this.recoveryMode = recoveryMode;
        this.indexEntries = new AvlTreeIndex();
        this.futureReads = new FutureReadResultEntryCollection();
        this.pendingMergers = new HashMap();
        this.lastAppendedOffset = -1L;
        this.storageReadManager = new StorageReadManager(metadata, storage, executor);
        this.executor = executor;
        this.summary = new ReadIndexSummary();
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean cleanCache) {
        if (!this.closed) {
            this.closed = true;
            this.storageReadManager.close();
            ArrayList<Iterator<FutureReadResultEntry>> futureReads = new ArrayList<Iterator<FutureReadResultEntry>>();
            futureReads.add(this.futureReads.close().iterator());
            Object object = this.lock;
            synchronized (object) {
                this.pendingMergers.values().forEach(pm -> futureReads.add(pm.seal().iterator()));
            }
            this.cancelFutureReads(Iterators.concat(futureReads.iterator()));
            if (cleanCache) {
                this.executor.execute(() -> {
                    this.removeAllEntries();
                    log.info("{}: Closed.", (Object)this.traceObjectId);
                });
            } else {
                log.info("{}: Closed (no cache cleanup).", (Object)this.traceObjectId);
            }
        }
    }

    private void cancelFutureReads(Iterator<FutureReadResultEntry> toCancel) {
        CancellationException ce = new CancellationException();
        while (toCancel.hasNext()) {
            FutureReadResultEntry e = toCancel.next();
            if (e.getContent().isDone()) continue;
            e.fail(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllEntries() {
        int count;
        Preconditions.checkState((boolean)this.closed, (Object)"Cannot call removeAllEntries unless the ReadIndex is closed.");
        Object object = this.lock;
        synchronized (object) {
            this.indexEntries.forEach(entry -> {
                if (entry.isDataEntry()) {
                    CacheKey key = this.getCacheKey((ReadIndexEntry)entry);
                    this.cache.remove((Cache.Key)key);
                }
            });
            count = this.indexEntries.size();
            this.indexEntries.clear();
        }
        if (count > 0) {
            log.debug("{}: Cleared all cache entries ({}).", (Object)this.traceObjectId, (Object)count);
        }
    }

    @Override
    public CacheManager.CacheStatus getCacheStatus() {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        return this.summary.toCacheStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateGenerations(int currentGeneration, int oldestGeneration) {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        this.summary.setCurrentGeneration(currentGeneration);
        AtomicLong sizeRemoved = new AtomicLong();
        ArrayList<ReadIndexEntry> toRemove = new ArrayList<ReadIndexEntry>();
        Object object = this.lock;
        synchronized (object) {
            this.indexEntries.forEach(entry -> {
                boolean canRemove;
                long lastOffset = entry.getLastStreamSegmentOffset();
                boolean bl = canRemove = entry.isDataEntry() && lastOffset < this.metadata.getStorageLength() && (entry.getGeneration() < oldestGeneration || lastOffset < this.metadata.getStartOffset());
                if (canRemove) {
                    toRemove.add((ReadIndexEntry)entry);
                }
            });
            toRemove.forEach(e -> {
                this.indexEntries.remove(e.key());
                this.cache.remove((Cache.Key)this.getCacheKey((ReadIndexEntry)e));
            });
        }
        toRemove.forEach(e -> {
            long entryLength = e.getLength();
            this.summary.remove(entryLength, e.getGeneration());
            sizeRemoved.addAndGet(entryLength);
        });
        return sizeRemoved.get();
    }

    public String toString() {
        return String.format("%s (%s)", this.traceObjectId, this.metadata.getName());
    }

    boolean isMerged() {
        return this.merged;
    }

    void markMerged() {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((!this.merged ? 1 : 0) != 0, (String)"StreamSegmentReadIndex %d is already merged.", (long)this.metadata.getId());
        log.debug("{}: Merged.", (Object)this.traceObjectId);
        this.merged = true;
    }

    boolean isActive() {
        return this.metadata.isActive() && !this.metadata.isDeleted();
    }

    long getSegmentLength() {
        return this.metadata.getLength();
    }

    private CacheKey getCacheKey(ReadIndexEntry entry) {
        if (entry instanceof MergedIndexEntry) {
            MergedIndexEntry me = (MergedIndexEntry)entry;
            return new CacheKey(me.getSourceSegmentId(), me.getSourceSegmentOffset());
        }
        return new CacheKey(this.metadata.getId(), entry.getStreamSegmentOffset());
    }

    public void exitRecoveryMode(SegmentMetadata newMetadata) {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((boolean)this.recoveryMode, (Object)"Read Index is not in recovery mode.");
        Preconditions.checkNotNull((Object)newMetadata, (Object)"newMetadata");
        Exceptions.checkArgument((newMetadata.getId() == this.metadata.getId() ? 1 : 0) != 0, (String)"newMetadata", (String)"New Metadata StreamSegmentId is different from existing one.", (Object[])new Object[0]);
        Exceptions.checkArgument((newMetadata.getLength() == this.metadata.getLength() ? 1 : 0) != 0, (String)"newMetadata", (String)"New Metadata Length is different from existing one.", (Object[])new Object[0]);
        Exceptions.checkArgument((newMetadata.getStorageLength() == this.metadata.getStorageLength() ? 1 : 0) != 0, (String)"newMetadata", (String)"New Metadata StorageLength is different from existing one.", (Object[])new Object[0]);
        Exceptions.checkArgument((newMetadata.isSealed() == this.metadata.isSealed() ? 1 : 0) != 0, (String)"newMetadata", (String)"New Metadata Sealed Flag is different from existing one.", (Object[])new Object[0]);
        Exceptions.checkArgument((newMetadata.isMerged() == this.metadata.isMerged() ? 1 : 0) != 0, (String)"newMetadata", (String)"New Metadata Merged Flag is different from existing one.", (Object[])new Object[0]);
        Exceptions.checkArgument((newMetadata.isDeleted() == this.metadata.isDeleted() ? 1 : 0) != 0, (String)"newMetadata", (String)"New Metadata Deletion Flag is different from existing one.", (Object[])new Object[0]);
        this.metadata = newMetadata;
        this.recoveryMode = false;
        log.debug("{}: Exit RecoveryMode.", (Object)this.traceObjectId);
    }

    void append(long offset, BufferView data) {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((!this.isMerged() ? 1 : 0) != 0, (Object)"StreamSegment has been merged into a different one. Cannot append more ReadIndex entries.");
        int dataLength = data.getLength();
        if (dataLength == 0) {
            return;
        }
        long endOffset = offset + (long)dataLength;
        long length = this.metadata.getLength();
        Exceptions.checkArgument((endOffset <= length ? 1 : 0) != 0, (String)"offset", (String)"The given range of bytes (%d-%d) is beyond the StreamSegment Length (%d).", (Object[])new Object[]{offset, endOffset, length});
        this.cache.insert((Cache.Key)new CacheKey(this.metadata.getId(), offset), data);
        this.appendEntry(new CacheIndexEntry(offset, dataLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginMerge(long offset, StreamSegmentReadIndex sourceStreamSegmentIndex) {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"beginMerge", (Object[])new Object[]{offset, sourceStreamSegmentIndex.traceObjectId});
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Exceptions.checkArgument((!sourceStreamSegmentIndex.isMerged() ? 1 : 0) != 0, (String)"sourceStreamSegmentIndex", (String)"Given StreamSegmentReadIndex is already merged.", (Object[])new Object[0]);
        SegmentMetadata sourceMetadata = sourceStreamSegmentIndex.metadata;
        Exceptions.checkArgument((boolean)sourceMetadata.isSealed(), (String)"sourceStreamSegmentIndex", (String)"Given StreamSegmentReadIndex refers to a StreamSegment that is not sealed.", (Object[])new Object[0]);
        long sourceLength = sourceStreamSegmentIndex.getSegmentLength();
        RedirectIndexEntry newEntry = new RedirectIndexEntry(offset, sourceStreamSegmentIndex);
        if (sourceLength == 0L) {
            return;
        }
        long endOffset = offset + sourceLength;
        long ourLength = this.getSegmentLength();
        Exceptions.checkArgument((endOffset <= ourLength ? 1 : 0) != 0, (String)"offset", (String)"The given range of bytes(%d-%d) is beyond the StreamSegment Length (%d).", (Object[])new Object[]{offset, endOffset, ourLength});
        Object object = this.lock;
        synchronized (object) {
            Exceptions.checkArgument((!this.pendingMergers.containsKey(sourceMetadata.getId()) ? 1 : 0) != 0, (String)"sourceStreamSegmentIndex", (String)"Given StreamSegmentReadIndex is already merged or in the process of being merged into this one.", (Object[])new Object[0]);
            this.pendingMergers.put(sourceMetadata.getId(), new PendingMerge(newEntry.key()));
        }
        try {
            this.appendEntry(newEntry);
        }
        catch (Exception ex) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.pendingMergers.remove(sourceMetadata.getId());
            }
            throw ex;
        }
        LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"beginMerge", (long)traceId, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeMerge(SegmentMetadata sourceMetadata) {
        RedirectIndexEntry redirectEntry;
        PendingMerge pendingMerge;
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"completeMerge", (Object[])new Object[]{sourceMetadata.getId()});
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Exceptions.checkArgument((boolean)sourceMetadata.isDeleted(), (String)"sourceSegmentStreamId", (String)"Given StreamSegmentReadIndex refers to a StreamSegment that has not been deleted yet.", (Object[])new Object[0]);
        if (sourceMetadata.getLength() == 0L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            pendingMerge = this.pendingMergers.getOrDefault(sourceMetadata.getId(), null);
            Exceptions.checkArgument((pendingMerge != null ? 1 : 0) != 0, (String)"sourceSegmentStreamId", (String)"Given StreamSegmentReadIndex's merger with this one has not been initiated using beginMerge. Cannot finalize the merger.", (Object[])new Object[0]);
            ReadIndexEntry indexEntry = (ReadIndexEntry)this.indexEntries.get(pendingMerge.getMergeOffset());
            assert (indexEntry != null && !indexEntry.isDataEntry()) : String.format("pendingMergers points to a ReadIndexEntry that does not exist or is of the wrong type. sourceStreamSegmentId = %d, offset = %d, treeEntry = %s.", sourceMetadata.getId(), pendingMerge.getMergeOffset(), indexEntry);
            redirectEntry = (RedirectIndexEntry)indexEntry;
        }
        StreamSegmentReadIndex sourceIndex = redirectEntry.getRedirectReadIndex();
        List<MergedIndexEntry> sourceEntries = sourceIndex.getAllEntries(redirectEntry.getStreamSegmentOffset());
        Object object2 = this.lock;
        synchronized (object2) {
            this.indexEntries.remove(pendingMerge.getMergeOffset());
            this.pendingMergers.remove(sourceMetadata.getId());
            sourceEntries.forEach(this::addToIndex);
        }
        List<FutureReadResultEntry> pendingReads = pendingMerge.seal();
        if (pendingReads.size() > 0) {
            log.debug("{}: triggerFutureReads for Pending Merge (Count = {}, MergeOffset = {}, MergeLength = {}).", new Object[]{this.traceObjectId, pendingReads.size(), pendingMerge.getMergeOffset(), sourceIndex.getSegmentLength()});
            this.triggerFutureReads(pendingReads);
        }
        LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"completeMerge", (long)traceId, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendEntry(ReadIndexEntry entry) {
        log.debug("{}: Append (Offset = {}, Length = {}).", new Object[]{this.traceObjectId, entry.getStreamSegmentOffset(), entry.getLength()});
        long lastOffset = entry.getLastStreamSegmentOffset();
        Object object = this.lock;
        synchronized (object) {
            Exceptions.checkArgument((this.lastAppendedOffset < 0L || entry.getStreamSegmentOffset() == this.lastAppendedOffset + 1L ? 1 : 0) != 0, (String)"entry", (String)"The given range of bytes (%d-%d) does not start right after the last appended range (%d).", (Object[])new Object[]{entry.getStreamSegmentOffset(), lastOffset, this.lastAppendedOffset});
            ReadIndexEntry oldEntry = this.addToIndex(entry);
            assert (oldEntry == null) : String.format("Added a new entry in the ReadIndex that overrode an existing element. New = %s, Old = %s.", entry, oldEntry);
            this.lastAppendedOffset = lastOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(long offset, ByteArraySegment data) {
        ReadIndexEntry oldEntry;
        log.debug("{}: Insert (Offset = {}, Length = {}).", new Object[]{this.traceObjectId, offset, data.getLength()});
        CacheIndexEntry entry = new CacheIndexEntry(offset, data.getLength());
        long lastOffset = entry.getLastStreamSegmentOffset();
        Exceptions.checkArgument((lastOffset < this.metadata.getStorageLength() ? 1 : 0) != 0, (String)"entry", (String)"The given range of bytes (%d-%d) does not correspond to the StreamSegment range that is in Storage (%d).", (Object[])new Object[]{entry.getStreamSegmentOffset(), lastOffset, this.metadata.getStorageLength()});
        Object object = this.lock;
        synchronized (object) {
            this.cache.insert((Cache.Key)this.getCacheKey(entry), (BufferView)data);
            oldEntry = this.addToIndex(entry);
        }
        if (oldEntry != null) {
            log.warn("{}: Insert overrode existing entry (Offset = {}, OldLength = {}, NewLength = {}).", new Object[]{this.traceObjectId, entry.getStreamSegmentOffset(), entry.getLength(), oldEntry.getLength()});
        }
    }

    @GuardedBy(value="lock")
    private ReadIndexEntry addToIndex(ReadIndexEntry entry) {
        ReadIndexEntry oldEntry = (ReadIndexEntry)this.indexEntries.put((SortedIndex.IndexEntry)entry);
        if (entry.isDataEntry()) {
            if (entry instanceof MergedIndexEntry) {
                this.summary.add(entry.getLength(), entry.getGeneration());
            } else {
                int generation = this.summary.add(entry.getLength());
                entry.setGeneration(generation);
            }
        }
        if (oldEntry != null && oldEntry.isDataEntry()) {
            this.summary.remove(oldEntry.getLength(), oldEntry.getGeneration());
        }
        return oldEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void triggerFutureReads() {
        Collection<FutureReadResultEntry> futureReads;
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((!this.recoveryMode ? 1 : 0) != 0, (Object)"StreamSegmentReadIndex is in Recovery Mode.");
        boolean sealed = this.metadata.isSealed();
        if (sealed) {
            futureReads = this.futureReads.pollAll();
            log.debug("{}: triggerFutureReads (Count = {}, Offset = {}, Sealed = True).", new Object[]{this.traceObjectId, futureReads.size(), this.metadata.getLength()});
        } else {
            ReadIndexEntry lastEntry;
            Object object = this.lock;
            synchronized (object) {
                lastEntry = (ReadIndexEntry)this.indexEntries.getLast();
            }
            if (lastEntry == null) {
                return;
            }
            futureReads = this.futureReads.poll(lastEntry.getLastStreamSegmentOffset());
            log.debug("{}: triggerFutureReads (Count = {}, Offset = {}, Sealed = False).", new Object[]{this.traceObjectId, futureReads.size(), lastEntry.getLastStreamSegmentOffset()});
        }
        this.triggerFutureReads(futureReads);
    }

    private void triggerFutureReads(Collection<FutureReadResultEntry> futureReads) {
        for (FutureReadResultEntry r : futureReads) {
            CompletableReadResultEntry entry = this.getSingleReadResultEntry(r.getStreamSegmentOffset(), r.getRequestedReadLength());
            assert (entry != null) : "Serving a StorageReadResultEntry with a null result";
            assert (!(entry instanceof FutureReadResultEntry)) : "Serving a FutureReadResultEntry with another FutureReadResultEntry.";
            log.trace("{}: triggerFutureReads (Offset = {}, Type = {}).", new Object[]{this.traceObjectId, r.getStreamSegmentOffset(), entry.getType()});
            if (entry.getType() == ReadResultEntryType.EndOfStreamSegment) {
                r.fail((Throwable)new StreamSegmentSealedException(String.format("StreamSegment has been sealed at offset %d. There can be no more reads beyond this offset.", this.metadata.getLength())));
                continue;
            }
            if (!entry.getContent().isDone()) {
                entry.requestContent(this.config.getStorageReadDefaultTimeout());
            }
            CompletableFuture entryContent = entry.getContent();
            entryContent.thenAccept(r::complete);
            Futures.exceptionListener((CompletableFuture)entryContent, r::fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream readDirect(long startOffset, int length) {
        int entryReadLength;
        CacheReadResultEntry nextEntry;
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((!this.recoveryMode ? 1 : 0) != 0, (Object)"StreamSegmentReadIndex is in Recovery Mode.");
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be a non-negative number");
        Preconditions.checkArgument((startOffset >= this.metadata.getStorageLength() ? 1 : 0) != 0, (Object)"startOffset must refer to an offset beyond the Segment's StorageLength offset.");
        Preconditions.checkArgument((startOffset + (long)length <= this.metadata.getLength() ? 1 : 0) != 0, (Object)"startOffset+length must be less than the length of the Segment.");
        Preconditions.checkArgument((startOffset >= Math.min(this.metadata.getStartOffset(), this.metadata.getStorageLength()) ? 1 : 0) != 0, (Object)"startOffset is before the Segment's StartOffset.");
        Object object = this.lock;
        synchronized (object) {
            ReadIndexEntry indexEntry = (ReadIndexEntry)this.indexEntries.getFloor(startOffset);
            if (indexEntry == null || startOffset > indexEntry.getLastStreamSegmentOffset() || !indexEntry.isDataEntry()) {
                return null;
            }
            nextEntry = this.createMemoryRead(indexEntry, startOffset, length, false);
        }
        assert (Futures.isSuccessful((CompletableFuture)nextEntry.getContent())) : "Found CacheReadResultEntry that is not completed yet: " + nextEntry;
        ReadResultEntryContents entryContents = (ReadResultEntryContents)nextEntry.getContent().join();
        ArrayList<InputStream> contents = new ArrayList<InputStream>();
        contents.add(entryContents.getData());
        for (int readLength = entryContents.getLength(); readLength < length; readLength += entryReadLength) {
            byte[] entryData = this.cache.get((Cache.Key)new CacheKey(this.metadata.getId(), startOffset + (long)readLength));
            if (entryData == null) {
                return null;
            }
            entryReadLength = Math.min(entryData.length, length - readLength);
            assert (entryReadLength > 0) : "about to have fetched zero bytes from a cache entry";
            contents.add(new ByteArrayInputStream(entryData, 0, entryReadLength));
        }
        return new SequenceInputStream(Iterators.asEnumeration(contents.iterator()));
    }

    ReadResult read(long startOffset, int maxLength, Duration timeout) {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((!this.recoveryMode ? 1 : 0) != 0, (Object)"StreamSegmentReadIndex is in Recovery Mode.");
        Exceptions.checkArgument((startOffset >= 0L ? 1 : 0) != 0, (String)"startOffset", (String)"startOffset must be a non-negative number.", (Object[])new Object[0]);
        Exceptions.checkArgument((maxLength >= 0 ? 1 : 0) != 0, (String)"maxLength", (String)"maxLength must be a non-negative number.", (Object[])new Object[0]);
        Exceptions.checkArgument((this.checkReadAvailability(startOffset, true) != ReadAvailability.BeyondLastOffset ? 1 : 0) != 0, (String)"startOffset", (String)"StreamSegment is sealed and startOffset is beyond the last offset of the StreamSegment.", (Object[])new Object[0]);
        log.debug("{}: Read (Offset = {}, MaxLength = {}).", new Object[]{this.traceObjectId, startOffset, maxLength});
        return new StreamSegmentReadResult(startOffset, maxLength, this::getMultiReadResultEntry, this.traceObjectId);
    }

    private ReadAvailability checkReadAvailability(long offset, boolean lastOffsetInclusive) {
        if (offset < this.metadata.getStartOffset()) {
            return ReadAvailability.BeforeStartOffset;
        }
        if (this.metadata.isSealed()) {
            return offset < this.metadata.getLength() + (long)(lastOffsetInclusive ? 1 : 0) ? ReadAvailability.Available : ReadAvailability.BeyondLastOffset;
        }
        return ReadAvailability.Available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableReadResultEntry getSingleReadResultEntry(long resultStartOffset, int maxLength) {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        if (maxLength < 0) {
            return null;
        }
        CompletableReadResultEntry result = null;
        ReadAvailability ra = this.checkReadAvailability(resultStartOffset, false);
        if (ra == ReadAvailability.BeyondLastOffset) {
            result = new EndOfStreamSegmentReadResultEntry(resultStartOffset, maxLength);
        } else if (ra == ReadAvailability.BeforeStartOffset) {
            result = new TruncatedReadResultEntry(resultStartOffset, maxLength, this.metadata.getStartOffset());
        } else {
            Object object = this.lock;
            synchronized (object) {
                ReadIndexEntry indexEntry = (ReadIndexEntry)this.indexEntries.getFloor(resultStartOffset);
                if (indexEntry == null) {
                    result = this.createDataNotAvailableRead(resultStartOffset, maxLength);
                } else if (resultStartOffset > indexEntry.getLastStreamSegmentOffset()) {
                    result = this.createDataNotAvailableRead(resultStartOffset, maxLength);
                } else if (indexEntry.isDataEntry()) {
                    result = this.createMemoryRead(indexEntry, resultStartOffset, maxLength, true);
                } else if (indexEntry instanceof RedirectIndexEntry) {
                    result = this.createRedirectedRead(resultStartOffset, maxLength, (RedirectIndexEntry)indexEntry);
                }
            }
        }
        assert (result != null) : String.format("Reached the end of getSingleReadResultEntry(id=%d, offset=%d, length=%d) with no plausible result in sight. This means we missed a case.", this.metadata.getId(), resultStartOffset, maxLength);
        return result;
    }

    private CompletableReadResultEntry getMultiReadResultEntry(long resultStartOffset, int maxLength) {
        ReadResultEntryContents entryContents;
        int readLength = 0;
        CompletableReadResultEntry nextEntry = this.getSingleReadResultEntry(resultStartOffset, maxLength);
        if (nextEntry == null || !(nextEntry instanceof CacheReadResultEntry)) {
            return nextEntry;
        }
        ArrayList<InputStream> contents = new ArrayList<InputStream>();
        do {
            assert (Futures.isSuccessful((CompletableFuture)nextEntry.getContent())) : "Found CacheReadResultEntry that is not completed yet: " + nextEntry;
            entryContents = (ReadResultEntryContents)nextEntry.getContent().join();
            contents.add(entryContents.getData());
        } while ((readLength += entryContents.getLength()) < this.config.getMemoryReadMinLength() && readLength < maxLength && (nextEntry = this.getSingleMemoryReadResultEntry(resultStartOffset + (long)readLength, maxLength - readLength)) != null);
        return new CacheReadResultEntry(resultStartOffset, new SequenceInputStream(Iterators.asEnumeration(contents.iterator())), readLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheReadResultEntry getSingleMemoryReadResultEntry(long resultStartOffset, int maxLength) {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        if (maxLength > 0 && this.checkReadAvailability(resultStartOffset, false) == ReadAvailability.Available) {
            Object object = this.lock;
            synchronized (object) {
                ReadIndexEntry indexEntry = (ReadIndexEntry)this.indexEntries.get(resultStartOffset);
                if (indexEntry != null && indexEntry.isDataEntry()) {
                    return this.createMemoryRead(indexEntry, resultStartOffset, maxLength, true);
                }
            }
        }
        return null;
    }

    private CompletableReadResultEntry createRedirectedRead(long streamSegmentOffset, int maxLength, RedirectIndexEntry entry) {
        CompletableReadResultEntry result;
        StreamSegmentReadIndex redirectedIndex = entry.getRedirectReadIndex();
        long redirectOffset = streamSegmentOffset - entry.getStreamSegmentOffset();
        long entryLength = entry.getLength();
        assert (redirectOffset >= 0L && redirectOffset < entryLength) : String.format("Redirected offset would be outside of the range of the Redirected StreamSegment. StreamSegmentOffset = %d, MaxLength = %d, Entry.StartOffset = %d, Entry.Length = %d, RedirectOffset = %d.", streamSegmentOffset, maxLength, entry.getStreamSegmentOffset(), entryLength, redirectOffset);
        if (entryLength < (long)maxLength) {
            maxLength = (int)entryLength;
        }
        if ((result = redirectedIndex.getSingleReadResultEntry(redirectOffset, maxLength)) != null) {
            result = new RedirectedReadResultEntry(result, entry.getStreamSegmentOffset(), this::getOrRegisterRedirectedRead, redirectedIndex.metadata.getId());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableReadResultEntry getOrRegisterRedirectedRead(long resultStartOffset, int maxLength, long sourceSegmentId) {
        CompletableReadResultEntry result = this.getSingleReadResultEntry(resultStartOffset, maxLength);
        if (result instanceof RedirectedReadResultEntry) {
            PendingMerge pendingMerge;
            Object object = this.lock;
            synchronized (object) {
                pendingMerge = this.pendingMergers.getOrDefault(sourceSegmentId, null);
            }
            FutureReadResultEntry futureResult = new FutureReadResultEntry(result.getStreamSegmentOffset(), result.getRequestedReadLength());
            if (pendingMerge != null && pendingMerge.register(futureResult)) {
                result = futureResult;
                log.debug("{}: Registered Pending Merge Future Read {}.", (Object)this.traceObjectId, (Object)result);
            } else {
                if (pendingMerge == null) {
                    log.debug("{}: Could not find Pending Merge for Id {} for {}; re-issuing.", new Object[]{this.traceObjectId, sourceSegmentId, result});
                } else {
                    log.debug("{}: Pending Merge for id {} was sealed for {}; re-issuing.", new Object[]{this.traceObjectId, sourceSegmentId, result});
                }
                result = this.getSingleReadResultEntry(resultStartOffset, maxLength);
            }
        }
        return result;
    }

    private ReadResultEntryBase createDataNotAvailableRead(long streamSegmentOffset, int maxLength) {
        maxLength = this.getLengthUntilNextEntry(streamSegmentOffset, maxLength);
        long storageLength = this.metadata.getStorageLength();
        if (streamSegmentOffset < storageLength) {
            long actualReadLength = storageLength - streamSegmentOffset;
            if (actualReadLength > (long)maxLength) {
                actualReadLength = maxLength;
            }
            return this.createStorageRead(streamSegmentOffset, (int)actualReadLength);
        }
        return this.createFutureRead(streamSegmentOffset, maxLength);
    }

    @GuardedBy(value="lock")
    private CacheReadResultEntry createMemoryRead(ReadIndexEntry entry, long streamSegmentOffset, int maxLength, boolean updateStats) {
        assert (streamSegmentOffset >= entry.getStreamSegmentOffset()) : String.format("streamSegmentOffset{%d} < entry.getStreamSegmentOffset{%d}", streamSegmentOffset, entry.getStreamSegmentOffset());
        int entryOffset = (int)(streamSegmentOffset - entry.getStreamSegmentOffset());
        int length = (int)Math.min((long)maxLength, entry.getLength() - (long)entryOffset);
        assert (length > 0) : String.format("length{%d} <= 0. streamSegmentOffset = %d, maxLength = %d, entry.offset = %d, entry.length = %d", length, streamSegmentOffset, maxLength, entry.getStreamSegmentOffset(), entry.getLength());
        byte[] data = this.cache.get((Cache.Key)this.getCacheKey(entry));
        assert (data != null) : String.format("No Cache Entry could be retrieved for entry %s", entry);
        if (updateStats) {
            int generation = this.summary.touchOne(entry.getGeneration());
            entry.setGeneration(generation);
        }
        return new CacheReadResultEntry(entry.getStreamSegmentOffset(), data, entryOffset, length);
    }

    private ReadResultEntryBase createStorageRead(long streamSegmentOffset, int readLength) {
        return new StorageReadResultEntry(streamSegmentOffset, readLength, this::queueStorageRead);
    }

    private void queueStorageRead(long offset, int length, Consumer<ReadResultEntryContents> successCallback, Consumer<Throwable> failureCallback, Duration timeout) {
        Consumer<StorageReadManager.Result> doneCallback = result -> {
            ByteArraySegment data = result.getData();
            successCallback.accept(new ReadResultEntryContents(data.getReader(), data.getLength()));
            if (!result.isDerived()) {
                this.insert(offset, data);
            }
        };
        length = this.getReadAlignedLength(offset, length);
        this.storageReadManager.execute(new StorageReadManager.Request(offset, length, doneCallback, failureCallback, timeout));
    }

    @GuardedBy(value="lock")
    private int getLengthUntilNextEntry(long startOffset, int maxLength) {
        ReadIndexEntry ceilingEntry = (ReadIndexEntry)this.indexEntries.getCeiling(startOffset);
        if (ceilingEntry != null) {
            maxLength = (int)Math.min((long)maxLength, ceilingEntry.getStreamSegmentOffset() - startOffset);
        }
        return maxLength;
    }

    private int getReadAlignedLength(long offset, int readLength) {
        int lengthSinceLastMultiple = (int)(offset % (long)this.config.getStorageReadAlignment());
        return Math.min(readLength, this.config.getStorageReadAlignment() - lengthSinceLastMultiple);
    }

    private ReadResultEntryBase createFutureRead(long streamSegmentOffset, int maxLength) {
        FutureReadResultEntry entry = new FutureReadResultEntry(streamSegmentOffset, maxLength);
        this.futureReads.add(entry);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MergedIndexEntry> getAllEntries(long offsetAdjustment) {
        Exceptions.checkArgument((offsetAdjustment >= 0L ? 1 : 0) != 0, (String)"offsetAdjustment", (String)"offsetAdjustment must be a non-negative number.", (Object[])new Object[0]);
        Object object = this.lock;
        synchronized (object) {
            ArrayList<MergedIndexEntry> result = new ArrayList<MergedIndexEntry>(this.indexEntries.size());
            this.indexEntries.forEach(entry -> {
                if (entry.isDataEntry()) {
                    result.add(new MergedIndexEntry(entry.getStreamSegmentOffset() + offsetAdjustment, this.metadata.getId(), (CacheIndexEntry)entry));
                }
            });
            return result;
        }
    }

    private static enum ReadAvailability {
        Available,
        BeyondLastOffset,
        BeforeStartOffset;

    }
}

