/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.ReadResultEntry;
import io.pravega.segmentstore.contracts.ReadResultEntryContents;
import io.pravega.segmentstore.server.reading.CompletableReadResultEntry;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamSegmentReadResult
implements ReadResult {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamSegmentReadResult.class);
    private final String traceObjectId;
    private final long streamSegmentStartOffset;
    private final int maxResultLength;
    private final NextEntrySupplier getNextItem;
    private CompletableFuture<ReadResultEntryContents> lastEntryFuture;
    private int consumedLength;
    private boolean canRead;
    private boolean closed;

    StreamSegmentReadResult(long streamSegmentStartOffset, int maxResultLength, NextEntrySupplier getNextItem, String traceObjectId) {
        Exceptions.checkArgument((streamSegmentStartOffset >= 0L ? 1 : 0) != 0, (String)"streamSegmentStartOffset", (String)"streamSegmentStartOffset must be a non-negative number.", (Object[])new Object[0]);
        Exceptions.checkArgument((maxResultLength >= 0 ? 1 : 0) != 0, (String)"maxResultLength", (String)"maxResultLength must be a non-negative number.", (Object[])new Object[0]);
        Preconditions.checkNotNull((Object)getNextItem, (Object)"getNextItem");
        this.traceObjectId = traceObjectId;
        this.streamSegmentStartOffset = streamSegmentStartOffset;
        this.maxResultLength = maxResultLength;
        this.getNextItem = getNextItem;
        this.consumedLength = 0;
        this.canRead = true;
    }

    public long getStreamSegmentStartOffset() {
        return this.streamSegmentStartOffset;
    }

    public int getMaxResultLength() {
        return this.maxResultLength;
    }

    public int getConsumedLength() {
        return this.consumedLength;
    }

    public boolean isClosed() {
        return this.closed || !this.hasNext();
    }

    public String toString() {
        return String.format("Offset = %d, MaxLength = %d, Consumed = %d", this.streamSegmentStartOffset, this.maxResultLength, this.consumedLength);
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            CompletableFuture<ReadResultEntryContents> lastReturnedFuture = this.lastEntryFuture;
            if (lastReturnedFuture != null && !lastReturnedFuture.isDone()) {
                lastReturnedFuture.cancel(true);
                this.lastEntryFuture = null;
            }
            log.trace("{}.ReadResult[{}]: Closed.", (Object)this.traceObjectId, (Object)this.streamSegmentStartOffset);
        }
    }

    public boolean hasNext() {
        return !this.closed && this.canRead && this.consumedLength < this.maxResultLength;
    }

    public ReadResultEntry next() {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((this.lastEntryFuture == null || this.lastEntryFuture.isDone() ? 1 : 0) != 0, (Object)"Cannot request a new entry when the previous one hasn't completed retrieval yet.");
        if (this.lastEntryFuture != null && !this.lastEntryFuture.isDone()) {
            this.lastEntryFuture.join();
        }
        if (!this.hasNext()) {
            return null;
        }
        long startOffset = this.streamSegmentStartOffset + (long)this.consumedLength;
        int remainingLength = this.maxResultLength - this.consumedLength;
        CompletableReadResultEntry entry = (CompletableReadResultEntry)this.getNextItem.apply(startOffset, remainingLength);
        if (entry == null) {
            assert (remainingLength <= 0) : String.format("No ReadResultEntry received when one was expected. Offset %d, MaxLen %d.", startOffset, remainingLength);
            this.lastEntryFuture = null;
        } else {
            assert (entry.getStreamSegmentOffset() == startOffset) : String.format("Invalid ReadResultEntry. Expected offset %d, given %d.", startOffset, entry.getStreamSegmentOffset());
            if (entry.getType().isTerminal()) {
                this.lastEntryFuture = null;
                this.canRead = false;
            } else {
                entry.setCompletionCallback(length -> this.consumedLength += length.intValue());
                this.lastEntryFuture = entry.getContent();
                Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
            }
        }
        log.trace("{}.ReadResult[{}]: Consumed = {}, MaxLength = {}, Entry = ({}).", new Object[]{this.traceObjectId, this.streamSegmentStartOffset, this.consumedLength, this.maxResultLength, entry});
        return entry;
    }

    @FunctionalInterface
    static interface NextEntrySupplier
    extends BiFunction<Long, Integer, CompletableReadResultEntry> {
    }
}

