/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.store;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.concurrent.Futures;
import io.pravega.segmentstore.contracts.ContainerNotFoundException;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentContainerRegistry;
import io.pravega.shared.segment.SegmentToContainerMapper;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SegmentContainerCollection {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(SegmentContainerCollection.class);
    private final SegmentContainerRegistry segmentContainerRegistry;
    private final SegmentToContainerMapper segmentToContainerMapper;

    public SegmentContainerCollection(SegmentContainerRegistry segmentContainerRegistry, SegmentToContainerMapper segmentToContainerMapper) {
        this.segmentContainerRegistry = (SegmentContainerRegistry)Preconditions.checkNotNull((Object)segmentContainerRegistry, (Object)"segmentContainerRegistry");
        this.segmentToContainerMapper = (SegmentToContainerMapper)Preconditions.checkNotNull((Object)segmentToContainerMapper, (Object)"segmentToContainerMapper");
    }

    protected <T> CompletableFuture<T> invoke(String streamSegmentName, Function<SegmentContainer, CompletableFuture<T>> toInvoke, String methodName, Object ... logArgs) {
        SegmentContainer container;
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)methodName, (Object[])logArgs);
        try {
            int containerId = this.segmentToContainerMapper.getContainerId(streamSegmentName);
            container = this.segmentContainerRegistry.getContainer(containerId);
        }
        catch (ContainerNotFoundException ex) {
            return Futures.failedFuture((Throwable)ex);
        }
        CompletableFuture<T> resultFuture = toInvoke.apply(container);
        if (log.isTraceEnabled()) {
            resultFuture.thenAccept(r -> LoggerHelpers.traceLeave((Logger)log, (String)methodName, (long)traceId, (Object[])new Object[]{r}));
        }
        return resultFuture;
    }
}

