/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.store;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import io.pravega.segmentstore.server.CachePolicy;
import java.net.Inet4Address;
import java.time.Duration;

public class ServiceConfig {
    public static final Property<Integer> CONTAINER_COUNT = Property.named((String)"containerCount");
    public static final Property<Integer> THREAD_POOL_SIZE = Property.named((String)"threadPoolSize", (Object)30);
    public static final Property<Integer> STORAGE_THREAD_POOL_SIZE = Property.named((String)"storageThreadPoolSize", (Object)200);
    public static final Property<Integer> LISTENING_PORT = Property.named((String)"listeningPort", (Object)12345);
    public static final Property<Integer> PUBLISHED_PORT = Property.named((String)"publishedPort");
    public static final Property<String> LISTENING_IP_ADDRESS = Property.named((String)"listeningIPAddress", (Object)"");
    public static final Property<String> PUBLISHED_IP_ADDRESS = Property.named((String)"publishedIPAddress", (Object)"");
    public static final Property<String> ZK_URL = Property.named((String)"zkURL", (Object)"localhost:2181");
    public static final Property<Integer> ZK_RETRY_SLEEP_MS = Property.named((String)"zkRetrySleepMs", (Object)5000);
    public static final Property<Integer> ZK_RETRY_COUNT = Property.named((String)"zkRetryCount", (Object)5);
    public static final Property<Integer> ZK_SESSION_TIMEOUT_MS = Property.named((String)"zkSessionTimeoutMs", (Object)10000);
    public static final Property<Boolean> SECURE_ZK = Property.named((String)"secureZK", (Object)false);
    public static final Property<String> ZK_TRUSTSTORE_LOCATION = Property.named((String)"zkTrustStore", (Object)"");
    public static final Property<String> ZK_TRUST_STORE_PASSWORD_PATH = Property.named((String)"zkTrustStorePasswordPath", (Object)"");
    public static final Property<String> CLUSTER_NAME = Property.named((String)"clusterName", (Object)"pravega-cluster");
    public static final Property<DataLogType> DATALOG_IMPLEMENTATION = Property.named((String)"dataLogImplementation", (Object)((Object)DataLogType.INMEMORY));
    public static final Property<StorageType> STORAGE_IMPLEMENTATION = Property.named((String)"storageImplementation", (Object)((Object)StorageType.HDFS));
    public static final Property<Boolean> READONLY_SEGMENT_STORE = Property.named((String)"readOnlySegmentStore", (Object)false);
    public static final Property<Long> CACHE_POLICY_MAX_SIZE = Property.named((String)"cacheMaxSize", (Object)0x400000000L);
    public static final Property<Integer> CACHE_POLICY_TARGET_UTILIZATION = Property.named((String)"cacheTargetUtilizationPercent", (Object)85);
    public static final Property<Integer> CACHE_POLICY_MAX_UTILIZATION = Property.named((String)"cacheMaxUtilizationPercent", (Object)98);
    public static final Property<Integer> CACHE_POLICY_MAX_TIME = Property.named((String)"cacheMaxTimeSeconds", (Object)1800);
    public static final Property<Integer> CACHE_POLICY_GENERATION_TIME = Property.named((String)"cacheGenerationTimeSeconds", (Object)1);
    public static final Property<Boolean> REPLY_WITH_STACK_TRACE_ON_ERROR = Property.named((String)"replyWithStackTraceOnError", (Object)false);
    public static final Property<String> INSTANCE_ID = Property.named((String)"instanceId", (Object)"");
    public static final Property<Boolean> ENABLE_TLS = Property.named((String)"enableTls", (Object)false);
    public static final Property<String> CERT_FILE = Property.named((String)"certFile", (Object)"");
    public static final Property<String> KEY_FILE = Property.named((String)"keyFile", (Object)"");
    public static final Property<Boolean> ENABLE_TLS_RELOAD = Property.named((String)"enableTlsReload", (Object)false);
    public static final String COMPONENT_CODE = "pravegaservice";
    private final int containerCount;
    private final int coreThreadPoolSize;
    private final int storageThreadPoolSize;
    private final int listeningPort;
    private final String listeningIPAddress;
    private final int publishedPort;
    private final String publishedIPAddress;
    private final String zkURL;
    private final int zkRetrySleepMs;
    private final int zkSessionTimeoutMs;
    private final int zkRetryCount;
    private final boolean secureZK;
    private final String zkTrustStore;
    private final String zkTrustStorePasswordPath;
    private final String clusterName;
    private final DataLogType dataLogTypeImplementation;
    private final StorageType storageImplementation;
    private final boolean readOnlySegmentStore;
    private final boolean enableTls;
    private final String certFile;
    private final String keyFile;
    private final boolean enableTlsReload;
    private final CachePolicy cachePolicy;
    private final boolean replyWithStackTraceOnError;
    private final String instanceId;

    private ServiceConfig(TypedProperties properties) throws ConfigurationException {
        int publishedPort;
        this.containerCount = properties.getInt(CONTAINER_COUNT);
        this.coreThreadPoolSize = properties.getInt(THREAD_POOL_SIZE);
        this.storageThreadPoolSize = properties.getInt(STORAGE_THREAD_POOL_SIZE);
        this.listeningPort = properties.getInt(LISTENING_PORT);
        try {
            publishedPort = properties.getInt(PUBLISHED_PORT);
        }
        catch (ConfigurationException e) {
            publishedPort = this.listeningPort;
        }
        this.publishedPort = publishedPort;
        String ipAddress = properties.get(LISTENING_IP_ADDRESS);
        if (ipAddress == null || ipAddress.equals(LISTENING_IP_ADDRESS.getDefaultValue())) {
            ipAddress = ServiceConfig.getHostAddress();
        }
        this.listeningIPAddress = ipAddress;
        String publishedIPAddress = properties.get(PUBLISHED_IP_ADDRESS);
        this.publishedIPAddress = Strings.isNullOrEmpty((String)publishedIPAddress) ? this.listeningIPAddress : publishedIPAddress;
        this.zkURL = properties.get(ZK_URL);
        this.zkRetrySleepMs = properties.getInt(ZK_RETRY_SLEEP_MS);
        this.zkRetryCount = properties.getInt(ZK_RETRY_COUNT);
        this.zkSessionTimeoutMs = properties.getInt(ZK_SESSION_TIMEOUT_MS);
        this.clusterName = properties.get(CLUSTER_NAME);
        this.dataLogTypeImplementation = (DataLogType)properties.getEnum(DATALOG_IMPLEMENTATION, DataLogType.class);
        this.storageImplementation = (StorageType)properties.getEnum(STORAGE_IMPLEMENTATION, StorageType.class);
        this.readOnlySegmentStore = properties.getBoolean(READONLY_SEGMENT_STORE);
        this.secureZK = properties.getBoolean(SECURE_ZK);
        this.zkTrustStore = properties.get(ZK_TRUSTSTORE_LOCATION);
        this.zkTrustStorePasswordPath = properties.get(ZK_TRUST_STORE_PASSWORD_PATH);
        this.enableTls = properties.getBoolean(ENABLE_TLS);
        this.keyFile = properties.get(KEY_FILE);
        this.certFile = properties.get(CERT_FILE);
        this.enableTlsReload = properties.getBoolean(ENABLE_TLS_RELOAD);
        long cachePolicyMaxSize = properties.getLong(CACHE_POLICY_MAX_SIZE);
        double cachePolicyTargetUtilization = (double)properties.getInt(CACHE_POLICY_TARGET_UTILIZATION) / 100.0;
        double cachePolicyMaxUtilization = (double)properties.getInt(CACHE_POLICY_MAX_UTILIZATION) / 100.0;
        int cachePolicyMaxTime = properties.getInt(CACHE_POLICY_MAX_TIME);
        int cachePolicyGenerationTime = properties.getInt(CACHE_POLICY_GENERATION_TIME);
        this.cachePolicy = new CachePolicy(cachePolicyMaxSize, cachePolicyTargetUtilization, cachePolicyMaxUtilization, Duration.ofSeconds(cachePolicyMaxTime), Duration.ofSeconds(cachePolicyGenerationTime));
        this.replyWithStackTraceOnError = properties.getBoolean(REPLY_WITH_STACK_TRACE_ON_ERROR);
        this.instanceId = properties.get(INSTANCE_ID);
    }

    public static ConfigBuilder<ServiceConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, ServiceConfig::new);
    }

    public String toString() {
        return String.format("%s(", this.getClass().getSimpleName()) + String.format("containerCount: %d, ", this.containerCount) + String.format("coreThreadPoolSize: %d, ", this.coreThreadPoolSize) + String.format("storageThreadPoolSize: %d, ", this.storageThreadPoolSize) + String.format("listeningPort: %d, ", this.listeningPort) + String.format("listeningIPAddress: %s, ", this.listeningIPAddress) + String.format("publishedPort: %d, ", this.publishedPort) + String.format("publishedIPAddress: %s, ", this.publishedIPAddress) + String.format("zkURL: %s, ", this.zkURL) + String.format("zkRetrySleepMs: %d, ", this.zkRetrySleepMs) + String.format("zkSessionTimeoutMs: %d, ", this.zkSessionTimeoutMs) + String.format("zkRetryCount: %d, ", this.zkRetryCount) + String.format("secureZK: %b, ", this.secureZK) + String.format("zkTrustStore is %s, ", Strings.isNullOrEmpty((String)this.zkTrustStore) ? "unspecified" : "specified") + String.format("zkTrustStorePasswordPath is %s, ", Strings.isNullOrEmpty((String)this.zkTrustStorePasswordPath) ? "unspecified" : "specified") + String.format("clusterName: %s, ", this.clusterName) + String.format("dataLogTypeImplementation: %s, ", this.dataLogTypeImplementation.name()) + String.format("storageImplementation: %s, ", this.storageImplementation.name()) + String.format("readOnlySegmentStore: %b, ", this.readOnlySegmentStore) + String.format("enableTls: %b, ", this.enableTls) + String.format("certFile is %s, ", Strings.isNullOrEmpty((String)this.certFile) ? "unspecified" : "specified") + String.format("keyFile is %s, ", Strings.isNullOrEmpty((String)this.keyFile) ? "unspecified" : "specified") + String.format("enableTlsReload: %b, ", this.enableTlsReload) + String.format("cachePolicy is %s, ", this.cachePolicy != null ? this.cachePolicy.toString() : "null") + String.format("replyWithStackTraceOnError: %b, ", this.replyWithStackTraceOnError) + String.format("instanceId: %s", this.instanceId) + ")";
    }

    private static String getHostAddress() {
        return Inet4Address.getLocalHost().getHostAddress();
    }

    @SuppressFBWarnings(justification="generated code")
    public int getContainerCount() {
        return this.containerCount;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getCoreThreadPoolSize() {
        return this.coreThreadPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getStorageThreadPoolSize() {
        return this.storageThreadPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getListeningPort() {
        return this.listeningPort;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getListeningIPAddress() {
        return this.listeningIPAddress;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getPublishedPort() {
        return this.publishedPort;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getPublishedIPAddress() {
        return this.publishedIPAddress;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getZkURL() {
        return this.zkURL;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getZkRetrySleepMs() {
        return this.zkRetrySleepMs;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getZkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getZkRetryCount() {
        return this.zkRetryCount;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isSecureZK() {
        return this.secureZK;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getZkTrustStore() {
        return this.zkTrustStore;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getZkTrustStorePasswordPath() {
        return this.zkTrustStorePasswordPath;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getClusterName() {
        return this.clusterName;
    }

    @SuppressFBWarnings(justification="generated code")
    public DataLogType getDataLogTypeImplementation() {
        return this.dataLogTypeImplementation;
    }

    @SuppressFBWarnings(justification="generated code")
    public StorageType getStorageImplementation() {
        return this.storageImplementation;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isReadOnlySegmentStore() {
        return this.readOnlySegmentStore;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isEnableTls() {
        return this.enableTls;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getCertFile() {
        return this.certFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getKeyFile() {
        return this.keyFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isEnableTlsReload() {
        return this.enableTlsReload;
    }

    @SuppressFBWarnings(justification="generated code")
    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isReplyWithStackTraceOnError() {
        return this.replyWithStackTraceOnError;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getInstanceId() {
        return this.instanceId;
    }

    public static enum StorageType {
        EXTENDEDS3,
        FILESYSTEM,
        HDFS,
        INMEMORY;

    }

    public static enum DataLogType {
        BOOKKEEPER,
        INMEMORY;

    }
}

