/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

class CacheBucketOffset {
    private static final long FIRST_BIT = Long.MIN_VALUE;
    private final long segmentOffset;
    private final boolean removal;

    CacheBucketOffset(long segmentOffset, boolean isRemoval) {
        Preconditions.checkArgument((segmentOffset >= 0L ? 1 : 0) != 0, (Object)"segmentOffset must be a non-negative number.");
        this.segmentOffset = segmentOffset;
        this.removal = isRemoval;
    }

    long encode() {
        return this.removal ? this.segmentOffset | Long.MIN_VALUE : this.segmentOffset;
    }

    static CacheBucketOffset decode(long value) {
        return value < 0L ? new CacheBucketOffset(value ^ Long.MIN_VALUE, true) : new CacheBucketOffset(value, false);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CacheBucketOffset) {
            CacheBucketOffset other = (CacheBucketOffset)obj;
            return this.segmentOffset == other.segmentOffset && this.removal == other.removal;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.segmentOffset);
    }

    public String toString() {
        return String.format("%s%s", this.segmentOffset, this.removal ? " [DELETED]" : "");
    }

    @SuppressFBWarnings(justification="generated code")
    public long getSegmentOffset() {
        return this.segmentOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isRemoval() {
        return this.removal;
    }
}

