/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import io.pravega.common.Exceptions;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.tables.CacheBucketOffset;
import io.pravega.segmentstore.server.tables.SegmentKeyCache;
import io.pravega.segmentstore.server.tables.TableKeyBatch;
import io.pravega.segmentstore.storage.Cache;
import io.pravega.segmentstore.storage.CacheFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import lombok.NonNull;

class ContainerKeyCache
implements CacheManager.Client,
AutoCloseable {
    private final Cache cache;
    @GuardedBy(value="segmentCaches")
    private final Map<Long, SegmentKeyCache> segmentCaches;
    @GuardedBy(value="segmentCaches")
    private int currentCacheGeneration;
    private final AtomicBoolean closed;

    ContainerKeyCache(int containerId, @NonNull CacheFactory cacheFactory) {
        if (cacheFactory == null) {
            throw new NullPointerException("cacheFactory is marked @NonNull but is null");
        }
        this.cache = cacheFactory.getCache(String.format("Container_%d_TableKeys", containerId));
        this.segmentCaches = new HashMap<Long, SegmentKeyCache>();
        this.closed = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.cache.close();
            Map<Long, SegmentKeyCache> map = this.segmentCaches;
            synchronized (map) {
                this.segmentCaches.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheManager.CacheStatus getCacheStatus() {
        int minGen = 0;
        int maxGen = 0;
        long size = 0L;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            for (SegmentKeyCache e : this.segmentCaches.values()) {
                if (e == null) continue;
                CacheManager.CacheStatus cs = e.getCacheStatus();
                minGen = Math.min(minGen, cs.getOldestGeneration());
                maxGen = Math.max(maxGen, cs.getNewestGeneration());
                size += cs.getSize();
            }
        }
        return new CacheManager.CacheStatus(size, minGen, maxGen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateGenerations(int currentGeneration, int oldestGeneration) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        ArrayList<SegmentKeyCache.EvictionResult> evictions = new ArrayList<SegmentKeyCache.EvictionResult>();
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            this.currentCacheGeneration = currentGeneration;
            for (SegmentKeyCache segmentCache : this.segmentCaches.values()) {
                evictions.add(segmentCache.evictBefore(oldestGeneration));
            }
        }
        return evictions.stream().mapToLong(this::evict).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Long> includeUpdateBatch(long segmentId, TableKeyBatch batch, long batchOffset) {
        SegmentKeyCache cache;
        int generation;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            cache = this.segmentCaches.computeIfAbsent(segmentId, s -> new SegmentKeyCache((long)s, this.cache));
        }
        return cache.includeUpdateBatch(batch, batchOffset, generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void includeTailCache(long segmentId, Map<UUID, CacheBucketOffset> keyOffsets) {
        SegmentKeyCache cache;
        int generation;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            cache = this.segmentCaches.computeIfAbsent(segmentId, s -> new SegmentKeyCache((long)s, this.cache));
        }
        cache.includeTailCache(keyOffsets, generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long includeExistingKey(long segmentId, UUID keyHash, long segmentOffset) {
        SegmentKeyCache cache;
        int generation;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            cache = this.segmentCaches.computeIfAbsent(segmentId, s -> new SegmentKeyCache((long)s, this.cache));
        }
        return cache.includeExistingKey(keyHash, segmentOffset, generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheBucketOffset get(long segmentId, UUID keyHash) {
        SegmentKeyCache cache;
        int generation;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            cache = this.segmentCaches.get(segmentId);
        }
        return cache == null ? null : cache.get(keyHash, generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSegmentIndexOffset(long segmentId, long indexOffset) {
        SegmentKeyCache cache;
        int generation;
        boolean remove = indexOffset < 0L;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            cache = remove ? this.segmentCaches.remove(segmentId) : this.segmentCaches.computeIfAbsent(segmentId, s -> new SegmentKeyCache((long)s, this.cache));
        }
        if (cache != null) {
            if (remove) {
                this.evict(cache.evictAll());
            } else {
                cache.setLastIndexedOffset(indexOffset, generation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSegmentIndexOffsetIfMissing(long segmentId, Supplier<Long> indexOffsetGetter) {
        int generation;
        SegmentKeyCache cache = null;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            generation = this.currentCacheGeneration;
            if (!this.segmentCaches.containsKey(segmentId)) {
                cache = new SegmentKeyCache(segmentId, this.cache);
            }
        }
        if (cache != null) {
            cache.setLastIndexedOffset(indexOffsetGetter.get(), generation);
        }
    }

    long getSegmentIndexOffset(long segmentId) {
        return this.forSegmentCache(segmentId, SegmentKeyCache::getLastIndexedOffset, -1L);
    }

    long getBackpointer(long segmentId, long sourceOffset) {
        return this.forSegmentCache(segmentId, c -> c.getBackpointerOffset(sourceOffset), -1L);
    }

    Map<UUID, CacheBucketOffset> getTailHashes(long segmentId) {
        return this.forSegmentCache(segmentId, SegmentKeyCache::getTailBucketOffsets, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T forSegmentCache(long segmentId, Function<SegmentKeyCache, T> ifExists, T ifNotExists) {
        SegmentKeyCache cache;
        Map<Long, SegmentKeyCache> map = this.segmentCaches;
        synchronized (map) {
            cache = this.segmentCaches.get(segmentId);
        }
        return cache == null ? ifNotExists : ifExists.apply(cache);
    }

    private long evict(SegmentKeyCache.EvictionResult eviction) {
        eviction.getKeys().forEach(arg_0 -> ((Cache)this.cache).remove(arg_0));
        return eviction.getSize();
    }
}

