/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.io.SerializationException;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.BitConverter;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import lombok.NonNull;

class EntrySerializer {
    static final int HEADER_LENGTH = 17;
    static final int MAX_KEY_LENGTH = 8192;
    static final int MAX_SERIALIZATION_LENGTH = 0x100000;
    private static final int VERSION_POSITION = 0;
    private static final int KEY_POSITION = 1;
    private static final int VALUE_POSITION = 5;
    private static final int ENTRY_VERSION_POSITION = 9;
    private static final byte CURRENT_SERIALIZATION_VERSION = 0;
    private static final int NO_VALUE = -1;

    EntrySerializer() {
    }

    int getUpdateLength(@NonNull TableEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked @NonNull but is null");
        }
        return 17 + entry.getKey().getKey().getLength() + entry.getValue().getLength();
    }

    void serializeUpdate(@NonNull Collection<TableEntry> entries, byte[] target) {
        if (entries == null) {
            throw new NullPointerException("entries is marked @NonNull but is null");
        }
        int offset = 0;
        for (TableEntry e : entries) {
            offset = this.serializeUpdate(e, target, offset, Long.MIN_VALUE);
        }
    }

    private int serializeUpdate(@NonNull TableEntry entry, byte[] target, int targetOffset, long version) {
        if (entry == null) {
            throw new NullPointerException("entry is marked @NonNull but is null");
        }
        ArrayView key = entry.getKey().getKey();
        ArrayView value = entry.getValue();
        Preconditions.checkArgument((key.getLength() <= 8192 ? 1 : 0) != 0, (Object)"Key too large.");
        int serializationLength = this.getUpdateLength(entry);
        Preconditions.checkArgument((serializationLength <= 0x100000 ? 1 : 0) != 0, (Object)"Key+Value serialization too large.");
        Preconditions.checkElementIndex((int)(targetOffset + serializationLength - 1), (int)target.length, (String)"serialization does not fit in target buffer");
        targetOffset = this.writeHeader(target, targetOffset, key.getLength(), value.getLength(), version);
        System.arraycopy(key.array(), key.arrayOffset(), target, targetOffset, key.getLength());
        System.arraycopy(value.array(), value.arrayOffset(), target, targetOffset += key.getLength(), value.getLength());
        return targetOffset += value.getLength();
    }

    void serializeUpdateWithExplicitVersion(@NonNull Collection<TableEntry> entries, byte[] target) {
        if (entries == null) {
            throw new NullPointerException("entries is marked @NonNull but is null");
        }
        int offset = 0;
        for (TableEntry e : entries) {
            offset = this.serializeUpdate(e, target, offset, e.getKey().getVersion());
        }
    }

    int getRemovalLength(@NonNull TableKey key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return 17 + key.getKey().getLength();
    }

    void serializeRemoval(@NonNull Collection<TableKey> keys, byte[] target) {
        if (keys == null) {
            throw new NullPointerException("keys is marked @NonNull but is null");
        }
        int offset = 0;
        for (TableKey e : keys) {
            offset = this.serializeRemoval(e, target, offset);
        }
    }

    private int serializeRemoval(@NonNull TableKey tableKey, byte[] target, int targetOffset) {
        if (tableKey == null) {
            throw new NullPointerException("tableKey is marked @NonNull but is null");
        }
        ArrayView key = tableKey.getKey();
        Preconditions.checkArgument((key.getLength() <= 8192 ? 1 : 0) != 0, (Object)"Key too large.");
        int serializationLength = this.getRemovalLength(tableKey);
        Preconditions.checkElementIndex((int)(targetOffset + serializationLength - 1), (int)target.length, (String)"serialization does not fit in target buffer");
        targetOffset = this.writeHeader(target, targetOffset, key.getLength(), -1, Long.MIN_VALUE);
        System.arraycopy(key.array(), key.arrayOffset(), target, targetOffset, key.getLength());
        return targetOffset + key.getLength();
    }

    Header readHeader(@NonNull ArrayView input) throws SerializationException {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        byte version = input.get(0);
        int keyLength = BitConverter.readInt((ArrayView)input, (int)1);
        int valueLength = BitConverter.readInt((ArrayView)input, (int)5);
        long entryVersion = BitConverter.readLong((ArrayView)input, (int)9);
        this.validateHeader(keyLength, valueLength);
        return new Header(version, keyLength, valueLength, entryVersion);
    }

    Header readHeader(@NonNull InputStream input) throws IOException {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        byte version = (byte)input.read();
        int keyLength = BitConverter.readInt((InputStream)input);
        int valueLength = BitConverter.readInt((InputStream)input);
        long entryVersion = BitConverter.readLong((InputStream)input);
        this.validateHeader(keyLength, valueLength);
        return new Header(version, keyLength, valueLength, entryVersion);
    }

    private int writeHeader(byte[] target, int targetOffset, int keyLength, int valueLength, long entryVersion) {
        target[targetOffset] = 0;
        ++targetOffset;
        targetOffset += BitConverter.writeInt((byte[])target, (int)targetOffset, (int)keyLength);
        targetOffset += BitConverter.writeInt((byte[])target, (int)targetOffset, (int)valueLength);
        targetOffset += BitConverter.writeLong((byte[])target, (int)targetOffset, (long)entryVersion);
        return targetOffset;
    }

    private void validateHeader(int keyLength, int valueLength) throws SerializationException {
        if (keyLength <= 0 || keyLength > 8192 || valueLength < 0 && valueLength != -1 || keyLength + valueLength > 0x100000) {
            throw new SerializationException(String.format("Read header with invalid data. KeyLength=%s, ValueLength=%s", keyLength, valueLength));
        }
    }

    static class Header {
        private final byte serializationVersion;
        private final int keyLength;
        private final int valueLength;
        private final long entryVersion;

        int getKeyOffset() {
            return 17;
        }

        int getValueOffset() {
            Preconditions.checkState((!this.isDeletion() ? 1 : 0) != 0, (Object)"Cannot request value offset for a removal entry.");
            return 17 + this.keyLength;
        }

        int getTotalLength() {
            return 17 + this.keyLength + Math.max(0, this.valueLength);
        }

        boolean isDeletion() {
            return this.valueLength == -1;
        }

        public String toString() {
            return String.format("Length: {K=%s, V=%s}, EntryVersion: %s", this.keyLength, this.valueLength, this.entryVersion);
        }

        @ConstructorProperties(value={"serializationVersion", "keyLength", "valueLength", "entryVersion"})
        @SuppressFBWarnings(justification="generated code")
        private Header(byte serializationVersion, int keyLength, int valueLength, long entryVersion) {
            this.serializationVersion = serializationVersion;
            this.keyLength = keyLength;
            this.valueLength = valueLength;
            this.entryVersion = entryVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getKeyLength() {
            return this.keyLength;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getValueLength() {
            return this.valueLength;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getEntryVersion() {
            return this.entryVersion;
        }
    }
}

