/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.tables.TableBucket;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.NonNull;

class IndexReader {
    @NonNull
    protected final ScheduledExecutorService executor;

    long getLastIndexedOffset(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.INDEX_OFFSET, 0L);
    }

    long getEntryCount(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.ENTRY_COUNT, 0L);
    }

    long getTotalEntryCount(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.TOTAL_ENTRY_COUNT, 0L);
    }

    long getBucketCount(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.BUCKET_COUNT, 0L);
    }

    long getCompactionOffset(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.COMPACTION_OFFSET, 0L);
    }

    long getCompactionUtilizationThreshold(SegmentProperties segmentInfo) {
        return segmentInfo.getAttributes().getOrDefault(TableAttributes.MIN_UTILIZATION, 0L);
    }

    CompletableFuture<Map<UUID, TableBucket>> locateBuckets(DirectSegmentAccess segment, Collection<UUID> keyHashes, TimeoutTimer timer) {
        return segment.getAttributes(keyHashes, false, timer.getRemaining()).thenApply(attributes -> attributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new TableBucket((UUID)e.getKey(), (Long)e.getValue()))));
    }

    CompletableFuture<Long> getBackpointerOffset(DirectSegmentAccess segment, long offset, Duration timeout) {
        UUID key = this.getBackpointerAttributeKey(offset);
        return segment.getAttributes(Collections.singleton(key), false, timeout).thenApply(attributes -> {
            long result = attributes.getOrDefault(key, Long.MIN_VALUE);
            return result == Long.MIN_VALUE ? -1L : result;
        });
    }

    @VisibleForTesting
    CompletableFuture<List<Long>> getBucketOffsets(DirectSegmentAccess segment, TableBucket bucket, TimeoutTimer timer) {
        ArrayList result = new ArrayList();
        AtomicLong offset = new AtomicLong(bucket.getSegmentOffset());
        return Futures.loop(() -> offset.get() >= 0L, () -> {
            result.add(offset.get());
            return this.getBackpointerOffset(segment, offset.get(), timer.getRemaining());
        }, offset::set, (Executor)this.executor).thenApply(v -> result);
    }

    protected UUID getBackpointerAttributeKey(long offset) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be a non-negative number.");
        return new UUID(Long.MAX_VALUE, offset);
    }

    @VisibleForTesting
    static boolean isBackpointerAttributeKey(UUID key) {
        return key.getMostSignificantBits() == Long.MAX_VALUE;
    }

    @ConstructorProperties(value={"executor"})
    @SuppressFBWarnings(justification="generated code")
    public IndexReader(@NonNull ScheduledExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException("executor is marked @NonNull but is null");
        }
        this.executor = executor;
    }
}

