/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ArrayView;
import io.pravega.segmentstore.server.tables.KeyHasher;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;

class IteratorState {
    private static final Serializer SERIALIZER = new Serializer();
    @NonNull
    private final UUID keyHash;

    IteratorState(@NonNull UUID keyHash) {
        if (keyHash == null) {
            throw new NullPointerException("keyHash is marked @NonNull but is null");
        }
        Preconditions.checkArgument((boolean)KeyHasher.isValid(keyHash), (Object)"keyHash must be at least IteratorState.MIN_HASH and at most IteratorState.MAX_HASH.");
        this.keyHash = keyHash;
    }

    public String toString() {
        return String.format("Hash = %s", this.keyHash);
    }

    static IteratorState deserialize(byte[] data) throws IOException {
        return (IteratorState)SERIALIZER.deserialize(data);
    }

    public ArrayView serialize() {
        return SERIALIZER.serialize(this);
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public UUID getKeyHash() {
        return this.keyHash;
    }

    private static class Serializer
    extends VersionedSerializer.WithBuilder<IteratorState, IteratorStateBuilder> {
        private Serializer() {
        }

        protected IteratorStateBuilder newBuilder() {
            return new IteratorStateBuilder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, IteratorStateBuilder builder) throws IOException {
            builder.keyHash = revisionDataInput.readUUID();
        }

        private void write00(IteratorState state, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.length(16);
            revisionDataOutput.writeUUID(state.keyHash);
        }
    }

    private static class IteratorStateBuilder
    implements ObjectBuilder<IteratorState> {
        private UUID keyHash;

        private IteratorStateBuilder() {
        }

        public IteratorState build() {
            return new IteratorState(this.keyHash);
        }
    }
}

