/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.hash.HashHelper;
import io.pravega.common.util.BitConverter;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.tables.CacheBucketOffset;
import io.pravega.segmentstore.server.tables.TableKeyBatch;
import io.pravega.segmentstore.storage.Cache;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class SegmentKeyCache {
    private static final HashHelper HASH = HashHelper.seededWith((String)SegmentKeyCache.class.getName());
    private static final int VALUE_SERIALIZATION_LENGTH = 8;
    private final long segmentId;
    private final Cache cache;
    @GuardedBy(value="this")
    private long lastIndexedOffset;
    @GuardedBy(value="this")
    private final HashMap<Long, Long> backpointers = new HashMap();
    @GuardedBy(value="this")
    private final HashMap<Short, CacheEntry> cacheEntries = new HashMap();
    @GuardedBy(value="this")
    private final HashMap<UUID, CacheBucketOffset> tailOffsets = new HashMap();

    synchronized CacheManager.CacheStatus getCacheStatus() {
        int minGen = 0;
        int maxGen = 0;
        long size = 0L;
        for (CacheEntry e : this.cacheEntries.values()) {
            if (e == null) continue;
            int g = e.getGeneration();
            minGen = Math.min(minGen, g);
            maxGen = Math.max(maxGen, g);
            size += (long)e.getSize();
        }
        return new CacheManager.CacheStatus(size, minGen, maxGen);
    }

    synchronized EvictionResult evictBefore(int oldestGeneration) {
        long sizeRemoved = 0L;
        ArrayList<Short> removedGroups = new ArrayList<Short>();
        for (Map.Entry<Short, CacheEntry> e : this.cacheEntries.entrySet()) {
            CacheEntry entry = e.getValue();
            if (entry.getGeneration() >= oldestGeneration || entry.getHighestOffset() >= this.lastIndexedOffset) continue;
            removedGroups.add(e.getKey());
            sizeRemoved += (long)entry.getSize();
        }
        removedGroups.forEach(this.cacheEntries::remove);
        return new EvictionResult(sizeRemoved, removedGroups.stream().map(x$0 -> new CacheKey((short)x$0)).collect(Collectors.toList()));
    }

    EvictionResult evictAll() {
        return this.evictBefore(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Long> includeUpdateBatch(TableKeyBatch batch, long batchOffset, int generation) {
        ArrayList<Long> result = new ArrayList<Long>(batch.getItems().size());
        SegmentKeyCache segmentKeyCache = this;
        synchronized (segmentKeyCache) {
            for (TableKeyBatch.Item item : batch.getItems()) {
                long itemOffset = batchOffset + (long)item.getOffset();
                CacheBucketOffset existingOffset = this.get(item.getHash(), generation);
                if (existingOffset == null || itemOffset > existingOffset.getSegmentOffset()) {
                    this.tailOffsets.put(item.getHash(), new CacheBucketOffset(itemOffset, batch.isRemoval()));
                    result.add(itemOffset);
                } else {
                    result.add(existingOffset.getSegmentOffset());
                }
                if (existingOffset == null) continue;
                this.backpointers.put(itemOffset, existingOffset.getSegmentOffset());
            }
        }
        return result;
    }

    synchronized void includeTailCache(Map<UUID, CacheBucketOffset> keyOffsets, int generation) {
        for (Map.Entry<UUID, CacheBucketOffset> e : keyOffsets.entrySet()) {
            CacheBucketOffset offset = e.getValue();
            CacheBucketOffset existingOffset = this.get(e.getKey(), generation);
            if (existingOffset != null && offset.getSegmentOffset() <= existingOffset.getSegmentOffset()) continue;
            this.tailOffsets.put(e.getKey(), offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long includeExistingKey(UUID keyHash, long segmentOffset, int generation) {
        CacheEntry entry;
        Preconditions.checkArgument((segmentOffset >= 0L ? 1 : 0) != 0, (Object)"segmentOffset must be non-negative.");
        short hashGroup = this.getHashGroup(keyHash);
        SegmentKeyCache segmentKeyCache = this;
        synchronized (segmentKeyCache) {
            CacheBucketOffset tailOffset = this.tailOffsets.get(keyHash);
            if (tailOffset != null && tailOffset.getSegmentOffset() >= segmentOffset) {
                return tailOffset.getSegmentOffset();
            }
            entry = this.cacheEntries.computeIfAbsent(hashGroup, hg -> new CacheEntry(hashGroup, generation));
        }
        entry.update(keyHash, segmentOffset, generation);
        return segmentOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheBucketOffset get(UUID keyHash, int generation) {
        Long r;
        CacheEntry entry;
        SegmentKeyCache segmentKeyCache = this;
        synchronized (segmentKeyCache) {
            CacheBucketOffset tailOffset = this.tailOffsets.get(keyHash);
            if (tailOffset != null) {
                return tailOffset;
            }
            entry = this.cacheEntries.get(this.getHashGroup(keyHash));
        }
        if (entry != null && (r = entry.get(keyHash, generation)) != null) {
            return CacheBucketOffset.decode(r);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastIndexedOffset(long currentLastIndexedOffset, int cacheGeneration) {
        ArrayList<MigrationCandidate> candidates = new ArrayList<MigrationCandidate>();
        SegmentKeyCache segmentKeyCache = this;
        synchronized (segmentKeyCache) {
            Preconditions.checkArgument((currentLastIndexedOffset >= this.lastIndexedOffset ? 1 : 0) != 0, (String)"currentLastIndexedOffset (%s) must be at least the current value (%s).", (long)currentLastIndexedOffset, (long)this.lastIndexedOffset);
            this.lastIndexedOffset = currentLastIndexedOffset;
            this.backpointers.keySet().removeIf(sourceOffset -> sourceOffset < currentLastIndexedOffset);
            for (Map.Entry<UUID, CacheBucketOffset> tailHash : this.tailOffsets.entrySet()) {
                CacheBucketOffset offset = tailHash.getValue();
                if (offset.getSegmentOffset() >= currentLastIndexedOffset) continue;
                CacheEntry cacheEntry = this.cacheEntries.computeIfAbsent(this.getHashGroup(tailHash.getKey()), hg -> new CacheEntry((short)hg, cacheGeneration));
                candidates.add(new MigrationCandidate(tailHash.getKey(), cacheEntry, offset));
            }
        }
        candidates.forEach(mc -> mc.cacheEntry.update(mc.keyHash, mc.offset.encode(), cacheGeneration));
        segmentKeyCache = this;
        synchronized (segmentKeyCache) {
            candidates.forEach(c -> this.tailOffsets.remove(c.keyHash, c.offset));
        }
    }

    synchronized long getLastIndexedOffset() {
        return this.lastIndexedOffset;
    }

    synchronized long getBackpointerOffset(long sourceOffset) {
        return this.backpointers.getOrDefault(sourceOffset, -1L);
    }

    synchronized Map<UUID, CacheBucketOffset> getTailBucketOffsets() {
        return new HashMap<UUID, CacheBucketOffset>(this.tailOffsets);
    }

    public synchronized String toString() {
        return String.format("LIO = %s, Entries = %s, Backpointers = %s, BucketOffsets = %s.", this.lastIndexedOffset, this.cacheEntries.size(), this.backpointers.size(), this.tailOffsets.size());
    }

    private short getHashGroup(UUID keyHash) {
        return (short)HASH.hashToBucket(keyHash, Short.MAX_VALUE);
    }

    @ConstructorProperties(value={"segmentId", "cache"})
    @SuppressFBWarnings(justification="generated code")
    public SegmentKeyCache(long segmentId, Cache cache) {
        this.segmentId = segmentId;
        this.cache = cache;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getSegmentId() {
        return this.segmentId;
    }

    private class CacheEntry {
        private static final int HEADER_LENGTH = 4;
        private static final int HASH_LENGTH = 16;
        private static final int ENTRY_LENGTH = 28;
        private final short hashGroup;
        @GuardedBy(value="this")
        private int generation;
        @GuardedBy(value="this")
        private int size;
        @GuardedBy(value="this")
        private long highestOffset;

        CacheEntry(short hashGroup, int currentGeneration) {
            this.hashGroup = hashGroup;
            this.generation = currentGeneration;
            this.size = 0;
            this.highestOffset = 0L;
        }

        synchronized int getGeneration() {
            return this.generation;
        }

        synchronized int getSize() {
            return this.size;
        }

        synchronized long getHighestOffset() {
            return this.highestOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Long get(UUID keyHash, int currentGeneration) {
            byte[] data = SegmentKeyCache.this.cache.get((Cache.Key)new CacheKey(this.hashGroup));
            int offset = this.locate(keyHash, data);
            if (offset >= 0) {
                CacheEntry cacheEntry = this;
                synchronized (cacheEntry) {
                    this.generation = currentGeneration;
                }
                return this.deserializeCacheValue(data, offset);
            }
            return null;
        }

        synchronized void update(UUID keyHash, long segmentOffset, int currentGeneration) {
            CacheKey key = new CacheKey(this.hashGroup);
            byte[] entryData = SegmentKeyCache.this.cache.get((Cache.Key)key);
            int entryOffset = this.locate(keyHash, entryData);
            if (entryOffset < 0) {
                if (entryData == null) {
                    entryData = new byte[28];
                    entryOffset = 4;
                } else {
                    byte[] newData = new byte[entryData.length + 16 + 8];
                    System.arraycopy(entryData, 0, newData, 0, entryData.length);
                    entryOffset = entryData.length;
                    entryData = newData;
                }
                int count = BitConverter.readInt((byte[])entryData, (int)0);
                BitConverter.writeInt((byte[])entryData, (int)0, (int)(count + 1));
                entryOffset += this.serializeHash(entryData, entryOffset, keyHash);
            }
            this.serializeCacheValue(segmentOffset, entryData, entryOffset);
            SegmentKeyCache.this.cache.insert((Cache.Key)key, entryData);
            this.size = entryData.length;
            this.generation = currentGeneration;
            this.highestOffset = Math.max(this.highestOffset, segmentOffset);
        }

        private int locate(UUID keyHash, byte[] data) {
            if (data != null && data.length > 0) {
                int count = BitConverter.readInt((byte[])data, (int)0);
                int offset = 4;
                byte[] keyHashArray = new byte[16];
                this.serializeHash(keyHashArray, 0, keyHash);
                for (int i = 0; i < count; ++i) {
                    boolean match = true;
                    for (int j = 0; j < 16; ++j) {
                        if (keyHashArray[j] == data[offset + j]) continue;
                        match = false;
                        break;
                    }
                    if (match) {
                        return offset + 16;
                    }
                    offset += 24;
                }
            }
            return -1;
        }

        private long deserializeCacheValue(byte[] input, int inputOffset) {
            return BitConverter.readLong((byte[])input, (int)inputOffset);
        }

        private void serializeCacheValue(long value, byte[] target, int targetOffset) {
            BitConverter.writeLong((byte[])target, (int)targetOffset, (long)value);
        }

        private int serializeHash(byte[] target, int targetOffset, UUID hash) {
            BitConverter.writeLong((byte[])target, (int)targetOffset, (long)hash.getMostSignificantBits());
            BitConverter.writeLong((byte[])target, (int)(targetOffset + 8), (long)hash.getLeastSignificantBits());
            return 16;
        }
    }

    class CacheKey
    extends Cache.Key {
        private static final int SERIALIZATION_LENGTH = 10;
        private final short keyHashGroup;

        public byte[] serialize() {
            byte[] result = new byte[10];
            BitConverter.writeLong((byte[])result, (int)0, (long)SegmentKeyCache.this.segmentId);
            BitConverter.writeShort((byte[])result, (int)8, (short)this.keyHashGroup);
            return result;
        }

        public int hashCode() {
            return this.keyHashGroup;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)((Object)obj);
            return this.keyHashGroup == other.keyHashGroup && this.getSegmentId() == other.getSegmentId();
        }

        private long getSegmentId() {
            return SegmentKeyCache.this.segmentId;
        }

        @ConstructorProperties(value={"keyHashGroup"})
        @SuppressFBWarnings(justification="generated code")
        private CacheKey(short keyHashGroup) {
            this.keyHashGroup = keyHashGroup;
        }
    }

    private static class MigrationCandidate {
        final UUID keyHash;
        final CacheEntry cacheEntry;
        final CacheBucketOffset offset;

        @ConstructorProperties(value={"keyHash", "cacheEntry", "offset"})
        @SuppressFBWarnings(justification="generated code")
        public MigrationCandidate(UUID keyHash, CacheEntry cacheEntry, CacheBucketOffset offset) {
            this.keyHash = keyHash;
            this.cacheEntry = cacheEntry;
            this.offset = offset;
        }
    }

    static class EvictionResult {
        private final long size;
        private final List<CacheKey> keys;

        @ConstructorProperties(value={"size", "keys"})
        @SuppressFBWarnings(justification="generated code")
        private EvictionResult(long size, List<CacheKey> keys) {
            this.size = size;
            this.keys = keys;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getSize() {
            return this.size;
        }

        @SuppressFBWarnings(justification="generated code")
        public List<CacheKey> getKeys() {
            return this.keys;
        }
    }
}

