/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.NonNull;

class TableBucket {
    static final long CORE_ATTRIBUTE_PREFIX = Long.MIN_VALUE;
    static final long BACKPOINTER_PREFIX = Long.MAX_VALUE;
    @NonNull
    private final UUID hash;
    private final long segmentOffset;

    boolean exists() {
        return this.segmentOffset >= 0L;
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableBucket) {
            return this.hash.equals(((TableBucket)obj).hash);
        }
        return false;
    }

    public String toString() {
        return String.format("Hash = %s, Offset = %s", this.hash, this.segmentOffset);
    }

    @ConstructorProperties(value={"hash", "segmentOffset"})
    @SuppressFBWarnings(justification="generated code")
    public TableBucket(@NonNull UUID hash, long segmentOffset) {
        if (hash == null) {
            throw new NullPointerException("hash is marked @NonNull but is null");
        }
        this.hash = hash;
        this.segmentOffset = segmentOffset;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public UUID getHash() {
        return this.hash;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getSegmentOffset() {
        return this.segmentOffset;
    }
}

