/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.HashedArray;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.reading.AsyncReadResultProcessor;
import io.pravega.segmentstore.server.tables.AsyncTableEntryReader;
import io.pravega.segmentstore.server.tables.EntrySerializer;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.NonNull;

abstract class TableBucketReader<ResultT> {
    protected final EntrySerializer serializer = new EntrySerializer();
    private final DirectSegmentAccess segment;
    private final GetBackpointer getBackpointer;
    private final Executor executor;

    static TableBucketReader<TableEntry> entry(@NonNull DirectSegmentAccess segment, @NonNull GetBackpointer getBackpointer, @NonNull Executor executor) {
        if (segment == null) {
            throw new NullPointerException("segment is marked @NonNull but is null");
        }
        if (getBackpointer == null) {
            throw new NullPointerException("getBackpointer is marked @NonNull but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked @NonNull but is null");
        }
        return new Entry(segment, getBackpointer, executor);
    }

    static TableBucketReader<TableKey> key(@NonNull DirectSegmentAccess segment, @NonNull GetBackpointer getBackpointer, @NonNull Executor executor) {
        if (segment == null) {
            throw new NullPointerException("segment is marked @NonNull but is null");
        }
        if (getBackpointer == null) {
            throw new NullPointerException("getBackpointer is marked @NonNull but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked @NonNull but is null");
        }
        return new Key(segment, getBackpointer, executor);
    }

    CompletableFuture<List<ResultT>> findAllExisting(long bucketOffset, TimeoutTimer timer) {
        HashMap result = new HashMap();
        BiConsumer<Object, Long> handler = (item, offset) -> {
            TableKey key = this.getKey(item);
            HashedArray indexedKey = new HashedArray(key.getKey());
            if (!result.containsKey(indexedKey)) {
                result.put(indexedKey, key.getVersion() == -1L ? null : item);
            }
        };
        return this.findAll(bucketOffset, handler, timer).thenApply(v -> result.values().stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    CompletableFuture<Void> findAll(long bucketOffset, BiConsumer<ResultT, Long> handler, TimeoutTimer timer) {
        AtomicLong offset = new AtomicLong(bucketOffset);
        return Futures.loop(() -> offset.get() >= 0L, () -> {
            ReadResult readResult = this.segment.read(offset.get(), this.getMaxReadLength(), timer.getRemaining());
            AsyncTableEntryReader<ResultT> reader = this.getReader(null, offset.get(), timer);
            AsyncReadResultProcessor.process(readResult, reader, this.executor);
            return reader.getResult().thenComposeAsync(entryResult -> {
                handler.accept(entryResult, offset.get());
                return this.getBackpointer.apply(this.segment, offset.get(), timer.getRemaining());
            }, this.executor);
        }, offset::set, (Executor)this.executor);
    }

    CompletableFuture<ResultT> find(ArrayView soughtKey, long bucketOffset, TimeoutTimer timer) {
        int maxReadLength = this.getMaxReadLength();
        AtomicLong offset = new AtomicLong(bucketOffset);
        CompletableFuture result = new CompletableFuture();
        Futures.loop(() -> !result.isDone(), () -> {
            ReadResult readResult = this.segment.read(offset.get(), maxReadLength, timer.getRemaining());
            AsyncTableEntryReader<ResultT> reader = this.getReader(soughtKey, offset.get(), timer);
            AsyncReadResultProcessor.process(readResult, reader, this.executor);
            return reader.getResult().thenComposeAsync(r -> {
                SearchContinuation sc = this.processResult(r, soughtKey);
                if (sc != SearchContinuation.ResultFound && sc != SearchContinuation.NoResult) {
                    return this.getBackpointer.apply(this.segment, offset.get(), timer.getRemaining()).thenAccept(newOffset -> {
                        offset.set((long)newOffset);
                        if (newOffset < 0L) {
                            result.complete(null);
                        }
                    });
                }
                result.complete(r);
                return CompletableFuture.completedFuture(null);
            }, this.executor);
        }, (Executor)this.executor).exceptionally(ex -> {
            result.completeExceptionally((Throwable)ex);
            return null;
        });
        return result;
    }

    protected abstract int getMaxReadLength();

    protected abstract AsyncTableEntryReader<ResultT> getReader(ArrayView var1, long var2, TimeoutTimer var4);

    protected abstract SearchContinuation processResult(ResultT var1, ArrayView var2);

    protected abstract TableKey getKey(ResultT var1);

    @ConstructorProperties(value={"segment", "getBackpointer", "executor"})
    @SuppressFBWarnings(justification="generated code")
    public TableBucketReader(DirectSegmentAccess segment, GetBackpointer getBackpointer, Executor executor) {
        this.segment = segment;
        this.getBackpointer = getBackpointer;
        this.executor = executor;
    }

    @FunctionalInterface
    static interface GetBackpointer {
        public CompletableFuture<Long> apply(DirectSegmentAccess var1, long var2, Duration var4);
    }

    private static enum SearchContinuation {
        ResultFound,
        Continue,
        NoResult;

    }

    private static class Key
    extends TableBucketReader<TableKey> {
        private Key(DirectSegmentAccess segment, GetBackpointer getBackpointer, Executor executor) {
            super(segment, getBackpointer, executor);
        }

        @Override
        protected int getMaxReadLength() {
            return 8209;
        }

        @Override
        protected AsyncTableEntryReader<TableKey> getReader(ArrayView soughtKey, long segmentOffset, TimeoutTimer timer) {
            return AsyncTableEntryReader.readKey(segmentOffset, this.serializer, timer);
        }

        @Override
        protected SearchContinuation processResult(TableKey result, ArrayView soughtKey) {
            if (HashedArray.arrayEquals((ArrayView)soughtKey, (ArrayView)result.getKey())) {
                return SearchContinuation.ResultFound;
            }
            return SearchContinuation.Continue;
        }

        @Override
        protected TableKey getKey(TableKey tableKey) {
            return tableKey;
        }
    }

    private static class Entry
    extends TableBucketReader<TableEntry> {
        private Entry(DirectSegmentAccess segment, GetBackpointer getBackpointer, Executor executor) {
            super(segment, getBackpointer, executor);
        }

        @Override
        protected int getMaxReadLength() {
            return 0x100000;
        }

        @Override
        protected AsyncTableEntryReader<TableEntry> getReader(ArrayView soughtKey, long segmentOffset, TimeoutTimer timer) {
            return AsyncTableEntryReader.readEntry(soughtKey, segmentOffset, this.serializer, timer);
        }

        @Override
        protected SearchContinuation processResult(TableEntry entry, ArrayView soughtKey) {
            if (entry == null) {
                return SearchContinuation.Continue;
            }
            if (entry.getValue() == null) {
                return SearchContinuation.NoResult;
            }
            return SearchContinuation.ResultFound;
        }

        @Override
        protected TableKey getKey(TableEntry tableEntry) {
            return tableEntry.getKey();
        }
    }
}

