/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.tables;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.AsyncIterator;
import io.pravega.segmentstore.server.AttributeIterator;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.tables.CacheBucketOffset;
import io.pravega.segmentstore.server.tables.KeyHasher;
import io.pravega.segmentstore.server.tables.TableBucket;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;

@ThreadSafe
class TableIterator<T>
implements AsyncIterator<T> {
    private final AttributeIterator indexHashIterator;
    private final ConvertResult<T> resultConverter;
    @GuardedBy(value="this")
    private final ArrayDeque<Map.Entry<UUID, Long>> cacheHashes;
    private final Executor executor;
    @GuardedBy(value="this")
    private Iterator<TableBucket> currentBatch = null;

    public CompletableFuture<T> getNext() {
        return this.getNextBucket().thenCompose(bucket -> {
            if (bucket == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.resultConverter.apply((TableBucket)bucket);
        });
    }

    private CompletableFuture<TableBucket> getNextBucket() {
        TableBucket fromBatch = this.getNextBucketFromExistingBatch();
        if (fromBatch != null) {
            return CompletableFuture.completedFuture(fromBatch);
        }
        AtomicBoolean canContinue = new AtomicBoolean(true);
        return Futures.loop(canContinue::get, this::fetchNextTableBuckets, canContinue::set, (Executor)this.executor).thenApply(v -> this.getNextBucketFromExistingBatch());
    }

    private synchronized TableBucket getNextBucketFromExistingBatch() {
        if (this.currentBatch != null) {
            TableBucket next = this.currentBatch.next();
            if (!this.currentBatch.hasNext()) {
                this.currentBatch = null;
            }
            return next;
        }
        return null;
    }

    private CompletableFuture<Boolean> fetchNextTableBuckets() {
        return this.indexHashIterator.getNext().thenApplyAsync(this::fetchNextTableBuckets, this.executor);
    }

    private synchronized boolean fetchNextTableBuckets(List<Map.Entry<UUID, Long>> indexHashes) {
        List<TableBucket> buckets = this.toBuckets(indexHashes);
        if (buckets == null) {
            return false;
        }
        if (!buckets.isEmpty()) {
            this.currentBatch = buckets.iterator();
            return false;
        }
        return true;
    }

    private synchronized List<TableBucket> toBuckets(List<Map.Entry<UUID, Long>> indexHashes) {
        ArrayList<TableBucket> buckets = new ArrayList<TableBucket>();
        if (indexHashes == null) {
            while (!this.cacheHashes.isEmpty()) {
                this.add(this.cacheHashes.removeFirst(), buckets);
            }
            return buckets.isEmpty() ? null : buckets;
        }
        for (Map.Entry<UUID, Long> indexHash : indexHashes) {
            if (!KeyHasher.isValid(indexHash.getKey()) || indexHash.getValue() == Long.MIN_VALUE) continue;
            boolean overridden = false;
            while (!this.cacheHashes.isEmpty()) {
                Map.Entry<UUID, Long> cacheHash = this.cacheHashes.peekFirst();
                int cmp = indexHash.getKey().compareTo(this.cacheHashes.peekFirst().getKey());
                if (cmp < 0) break;
                overridden = overridden || cmp == 0;
                this.add(cacheHash, buckets);
                this.cacheHashes.removeFirst();
            }
            if (overridden) continue;
            this.add(indexHash, buckets);
        }
        return buckets;
    }

    private void add(Map.Entry<UUID, Long> bucketInfo, List<TableBucket> buckets) {
        buckets.add(new TableBucket(bucketInfo.getKey(), bucketInfo.getValue()));
    }

    static <T> Builder<T> builder() {
        return new Builder();
    }

    static <T> TableIterator<T> empty() {
        return new TableIterator(() -> CompletableFuture.completedFuture(null), ignored -> CompletableFuture.completedFuture(null), new ArrayDeque<Map.Entry<UUID, Long>>(), ForkJoinPool.commonPool());
    }

    @ConstructorProperties(value={"indexHashIterator", "resultConverter", "cacheHashes", "executor"})
    @SuppressFBWarnings(justification="generated code")
    private TableIterator(AttributeIterator indexHashIterator, ConvertResult<T> resultConverter, ArrayDeque<Map.Entry<UUID, Long>> cacheHashes, Executor executor) {
        this.indexHashIterator = indexHashIterator;
        this.resultConverter = resultConverter;
        this.cacheHashes = cacheHashes;
        this.executor = executor;
    }

    @FunctionalInterface
    static interface ConvertResult<T> {
        public CompletableFuture<T> apply(TableBucket var1);
    }

    static class Builder<T> {
        private DirectSegmentAccess segment;
        private Map<UUID, CacheBucketOffset> cacheHashes;
        private UUID firstHash;
        private ConvertResult<T> resultConverter;
        private ScheduledExecutorService executor;
        private Duration fetchTimeout;

        Builder() {
        }

        Builder<T> segment(@NonNull DirectSegmentAccess segment) {
            if (segment == null) {
                throw new NullPointerException("segment is marked @NonNull but is null");
            }
            this.segment = segment;
            return this;
        }

        Builder<T> cacheHashes(@NonNull Map<UUID, CacheBucketOffset> cacheHashes) {
            if (cacheHashes == null) {
                throw new NullPointerException("cacheHashes is marked @NonNull but is null");
            }
            this.cacheHashes = cacheHashes;
            return this;
        }

        Builder<T> firstHash(@NonNull UUID firstHash) {
            if (firstHash == null) {
                throw new NullPointerException("firstHash is marked @NonNull but is null");
            }
            Preconditions.checkArgument((boolean)KeyHasher.isValid(firstHash), (Object)"Invalid firstHash.");
            this.firstHash = firstHash;
            return this;
        }

        Builder<T> executor(@NonNull ScheduledExecutorService executor) {
            if (executor == null) {
                throw new NullPointerException("executor is marked @NonNull but is null");
            }
            this.executor = executor;
            return this;
        }

        Builder<T> fetchTimeout(@NonNull Duration fetchTimeout) {
            if (fetchTimeout == null) {
                throw new NullPointerException("fetchTimeout is marked @NonNull but is null");
            }
            this.fetchTimeout = fetchTimeout;
            return this;
        }

        Builder<T> resultConverter(@NonNull ConvertResult<T> resultConverter) {
            if (resultConverter == null) {
                throw new NullPointerException("resultConverter is marked @NonNull but is null");
            }
            this.resultConverter = resultConverter;
            return this;
        }

        CompletableFuture<AsyncIterator<T>> build() {
            ArrayDeque<Map.Entry<UUID, Long>> cacheHashes = this.getCacheHashes(this.cacheHashes, this.firstHash);
            CompletableFuture<AttributeIterator> aiFuture = this.segment.attributeIterator(this.firstHash, KeyHasher.MAX_HASH, this.fetchTimeout);
            return aiFuture.thenApply(attributeIterator -> new TableIterator((AttributeIterator)attributeIterator, this.resultConverter, cacheHashes, this.executor).asSequential(this.executor));
        }

        private ArrayDeque<Map.Entry<UUID, Long>> getCacheHashes(Map<UUID, CacheBucketOffset> unindexedKeyHashes, UUID firstHash) {
            return unindexedKeyHashes.entrySet().stream().filter(e -> ((UUID)e.getKey()).compareTo(firstHash) >= 0).sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> Maps.immutableEntry(e.getKey(), (Object)((CacheBucketOffset)e.getValue()).getSegmentOffset())).collect(Collectors.toCollection(ArrayDeque::new));
        }
    }
}

