/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.writer;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.server.WriterSegmentProcessor;
import io.pravega.segmentstore.server.writer.WriterState;

class AckCalculator {
    private final WriterState state;

    AckCalculator(WriterState state) {
        Preconditions.checkNotNull((Object)state, (Object)"state");
        this.state = state;
    }

    <T extends WriterSegmentProcessor> long getHighestCommittedSequenceNumber(Iterable<T> processors) {
        long lowestUncommittedSeqNo = Long.MAX_VALUE;
        for (WriterSegmentProcessor a : processors) {
            long firstSeqNo;
            if (a.isClosed() || (firstSeqNo = a.getLowestUncommittedSequenceNumber()) < 0L) continue;
            lowestUncommittedSeqNo = Math.min(lowestUncommittedSeqNo, firstSeqNo - 1L);
        }
        lowestUncommittedSeqNo = Math.min(lowestUncommittedSeqNo, this.state.getLastReadSequenceNumber());
        return lowestUncommittedSeqNo;
    }

    <T extends WriterSegmentProcessor> long getLowestUncommittedSequenceNumber(Iterable<T> processors) {
        long result = Long.MAX_VALUE;
        for (WriterSegmentProcessor p : processors) {
            long sn = p.getLowestUncommittedSequenceNumber();
            if (sn < 0L || sn >= result) continue;
            result = sn;
        }
        return result == Long.MAX_VALUE ? Long.MIN_VALUE : result;
    }
}

